/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js.metrics;

import com.orange.decoder.js.metrics.NashornPropertyMapStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SamplingNashornPropertyMapStore
extends NashornPropertyMapStore {
    private static final Logger log = LoggerFactory.getLogger(SamplingNashornPropertyMapStore.class);
    private final long collectPeriodMs;
    private long lastCollect = 0L;

    public SamplingNashornPropertyMapStore(int referencesLimit, long collectPeriodMs) {
        super(referencesLimit);
        this.collectPeriodMs = collectPeriodMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryStart() {
        if (this.collectPeriodMs > 0L) {
            SamplingNashornPropertyMapStore samplingNashornPropertyMapStore = this;
            synchronized (samplingNashornPropertyMapStore) {
                long now = System.currentTimeMillis();
                if (now - this.lastCollect > this.collectPeriodMs) {
                    this.lastCollect = now;
                    this.removeClearedReferences();
                    return true;
                }
            }
        }
        return false;
    }

    public long getCollectPeriodMs() {
        return this.collectPeriodMs;
    }

    public long getLastCollect() {
        return this.lastCollect;
    }
}

