/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js.metrics;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.nashorn.internal.runtime.PropertyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NashornPropertyMapStore {
    private static final Logger log = LoggerFactory.getLogger(NashornPropertyMapStore.class);
    private final int referencesLimit;
    private final Set<UniqueWeakReference<PropertyMap>> references = Collections.synchronizedSet(new HashSet());

    void add(PropertyMap propertyMap) {
        this.removeClearedReferences();
        this.references.add(new UniqueWeakReference<PropertyMap>(propertyMap));
    }

    void removeClearedReferences() {
        this.references.removeIf(ref -> ref.get() == null);
        if (this.references.size() >= this.referencesLimit) {
            this.references.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long count() {
        Set<UniqueWeakReference<PropertyMap>> set = this.references;
        synchronized (set) {
            return this.references.stream().filter(ref -> ref.get() != null).count();
        }
    }

    public int getReferencesLimit() {
        return this.referencesLimit;
    }

    public Set<UniqueWeakReference<PropertyMap>> getReferences() {
        return this.references;
    }

    public NashornPropertyMapStore(int referencesLimit) {
        this.referencesLimit = referencesLimit;
    }

    static class UniqueWeakReference<T>
    extends WeakReference<T> {
        public UniqueWeakReference(T referent) {
            super(referent);
        }

        public int hashCode() {
            return this.get() == null ? super.hashCode() : this.get().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            if (this.get() == null) {
                return this.equals(obj);
            }
            return Objects.equals(this.get(), ((WeakReference)obj).get());
        }
    }
}

