/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js.metrics;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.orange.decoder.js.metrics.NashornPropertyMapStore;
import com.orange.decoder.js.metrics.SamplingNashornPropertyMapStore;
import com.orange.iaes.logging.LogUtils;
import com.orange.iaes.utils.MarkerUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.CompiledScript;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

class NashornCounterCollector {
    private static final Logger log = LoggerFactory.getLogger(NashornCounterCollector.class);
    private static final Method getScriptObjectMethod = Objects.requireNonNull(ReflectionUtils.findMethod(ScriptObjectMirror.class, "getScriptObject"));
    private static final Field getHistoryField = Objects.requireNonNull(ReflectionUtils.findField(PropertyMap.class, "history"));
    private static final Field getProtoHistoryField = Objects.requireNonNull(ReflectionUtils.findField(PropertyMap.class, "protoHistory"));
    private long scriptObjects = 0L;
    private long properties = 0L;
    private boolean propertyMapStoreActive = false;
    private final SamplingNashornPropertyMapStore bindingsPropertyMaps;
    private final NashornPropertyMapStore compiledScriptPropertyMaps;

    public void collect(CompiledScript compiledScript, Bindings bindings, int maxScriptDepth) {
        this.findScriptObject(compiledScript).ifPresent(scriptObject -> this.collectScripts(ImmutableMap.of("global", scriptObject).entrySet(), 0, maxScriptDepth).forEach(script -> this.compiledScriptPropertyMaps.add(script.getMap())));
        this.propertyMapStoreActive = this.bindingsPropertyMaps.tryStart();
        this.incrementCounters(this.collectScripts(ImmutableMap.of("global", bindings).entrySet(), 0, maxScriptDepth));
    }

    public static long getCompiledScriptHistoryCount(NashornPropertyMapStore store) {
        return NashornCounterCollector.getCompiledScriptFieldHistoryCount(store, getHistoryField);
    }

    public static long getCompiledScriptProtoHistoryCount(NashornPropertyMapStore store) {
        return NashornCounterCollector.getCompiledScriptFieldHistoryCount(store, getProtoHistoryField);
    }

    private static long getCompiledScriptFieldHistoryCount(NashornPropertyMapStore store, Field field) {
        return store.getReferences().stream().map(r -> Optional.ofNullable(r.get()).map(m3 -> NashornCounterCollector.getFieldHistorySize(m3, field)).orElse(0L)).reduce(0L, Long::sum);
    }

    private <K, V> List<ScriptObject> collectScripts(Set<Map.Entry<K, V>> entries, int depth, int maxScriptDepth) {
        try {
            if (depth >= maxScriptDepth) {
                log.debug("Max collect depth reached");
                return Collections.emptyList();
            }
            ArrayList<ScriptObject> maps = new ArrayList<ScriptObject>();
            if (entries != null) {
                for (Map.Entry<K, V> entry : entries) {
                    ScriptObject scriptObject;
                    if (entry.getValue() instanceof ScriptObjectMirror) {
                        scriptObject = (ScriptObject)getScriptObjectMethod.invoke(entry.getValue(), new Object[0]);
                        maps.add(scriptObject);
                        maps.addAll(this.collectScripts(scriptObject.entrySet(), depth + 1, maxScriptDepth));
                        continue;
                    }
                    if (!(entry.getValue() instanceof ScriptObject)) continue;
                    scriptObject = (ScriptObject)entry.getValue();
                    maps.add(scriptObject);
                    try {
                        maps.addAll(this.collectScripts(scriptObject.entrySet(), depth + 1, maxScriptDepth));
                    }
                    catch (Exception exception) {}
                }
            }
            return maps;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.info(MarkerUtils.warnDev(), "Unable to get counter {}", (Object)Throwables.getRootCause(e).getMessage());
            return Collections.emptyList();
        }
    }

    private void incrementCounters(List<ScriptObject> scripts) {
        this.scriptObjects += (long)scripts.size();
        scripts.stream().map(ScriptObject::getMap).collect(Collectors.toSet()).forEach(this::incrementCounters);
    }

    void incrementCounters(PropertyMap propertyMap) {
        this.properties += this.getPropertiesCount(propertyMap);
        if (this.propertyMapStoreActive) {
            this.bindingsPropertyMaps.add(propertyMap);
        }
    }

    long getPropertiesCount(PropertyMap propertyMap) {
        return propertyMap.size();
    }

    static long getFieldHistorySize(PropertyMap propertyMap, Field field) {
        try {
            WeakHashMap historyField = (WeakHashMap)field.get(propertyMap);
            return Objects.isNull(historyField) ? 0L : (long)historyField.size();
        }
        catch (Exception e) {
            log.info(MarkerUtils.warnDev(), "Unable to get history size {}", (Object)LogUtils.oneLineExceptionDetails((Throwable)e));
            return 0L;
        }
    }

    public Optional<ScriptObject> findScriptObject(CompiledScript script) {
        Field functionField = org.springframework.data.util.ReflectionUtils.findField(script.getClass(), f -> ScriptFunction.class.isAssignableFrom(f.getType()));
        if (functionField != null) {
            ReflectionUtils.makeAccessible(functionField);
            return Optional.ofNullable((ScriptObject)functionField.get(script));
        }
        return Optional.empty();
    }

    public long getScriptObjects() {
        return this.scriptObjects;
    }

    public long getProperties() {
        return this.properties;
    }

    public boolean isPropertyMapStoreActive() {
        return this.propertyMapStoreActive;
    }

    public SamplingNashornPropertyMapStore getBindingsPropertyMaps() {
        return this.bindingsPropertyMaps;
    }

    public NashornPropertyMapStore getCompiledScriptPropertyMaps() {
        return this.compiledScriptPropertyMaps;
    }

    public String toString() {
        return "NashornCounterCollector(scriptObjects=" + this.getScriptObjects() + ", properties=" + this.getProperties() + ", propertyMapStoreActive=" + this.isPropertyMapStoreActive() + ", bindingsPropertyMaps=" + this.getBindingsPropertyMaps() + ", compiledScriptPropertyMaps=" + this.getCompiledScriptPropertyMaps() + ")";
    }

    public NashornCounterCollector(SamplingNashornPropertyMapStore bindingsPropertyMaps, NashornPropertyMapStore compiledScriptPropertyMaps) {
        this.bindingsPropertyMaps = bindingsPropertyMaps;
        this.compiledScriptPropertyMaps = compiledScriptPropertyMaps;
    }

    static {
        ReflectionUtils.makeAccessible(getScriptObjectMethod);
        ReflectionUtils.makeAccessible(getHistoryField);
        ReflectionUtils.makeAccessible(getProtoHistoryField);
    }
}

