/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js.metrics;

import com.orange.decoder.js.metrics.NashornCounterCollector;
import com.orange.decoder.js.metrics.NashornPropertyMapStore;
import com.orange.decoder.js.metrics.SamplingNashornPropertyMapStore;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.CompiledScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsDecodingMetrics {
    private static final Logger log = LoggerFactory.getLogger(JsDecodingMetrics.class);
    private final Map<String, SamplingNashornPropertyMapStore> sampledPropertyMaps = new ConcurrentHashMap<String, SamplingNashornPropertyMapStore>();
    private final Map<String, NashornPropertyMapStore> compiledScriptPropertyMaps = new ConcurrentHashMap<String, NashornPropertyMapStore>();
    private MeterRegistry meterRegistry;
    private int maxScriptDepth;
    private int referencesCollectPeriodMs;
    private int referencesClearLimit;
    private static final String BINDINGS_SCRIPT_OBJECT_COUNT = "nashorn.script.object.count";
    private static final String BINDINGS_PROPERTIES_COUNT = "nashorn.script.object.properties.count";
    private static final String BINDINGS_MAP_RETAINED_GAUGE = "nashorn.script.object.map.retained";
    private static final String COMPILED_HISTORY_GAUGE = "nashorn.script.compiled.history.size";
    private static final String COMPILED_PROTO_HISTORY_GAUGE = "nashorn.script.compiled.protohistory.size";

    public void increment(CompiledScript compiledScript, Bindings bindings, String encoding) {
        this.compiledScriptPropertyMaps.putIfAbsent(encoding, new NashornPropertyMapStore(this.referencesClearLimit));
        this.sampledPropertyMaps.putIfAbsent(encoding, new SamplingNashornPropertyMapStore(this.referencesClearLimit, this.referencesCollectPeriodMs));
        NashornPropertyMapStore compiledScriptPropertyStore = this.compiledScriptPropertyMaps.get(encoding);
        NashornCounterCollector counters = new NashornCounterCollector(this.sampledPropertyMaps.get(encoding), compiledScriptPropertyStore);
        counters.collect(compiledScript, bindings, this.maxScriptDepth);
        Counter.builder(BINDINGS_SCRIPT_OBJECT_COUNT).tags("encoding", encoding).register(this.meterRegistry).increment(counters.getScriptObjects());
        Counter.builder(BINDINGS_PROPERTIES_COUNT).tags("encoding", encoding).register(this.meterRegistry).increment(counters.getProperties());
        Gauge.builder(COMPILED_PROTO_HISTORY_GAUGE, () -> NashornCounterCollector.getCompiledScriptProtoHistoryCount(compiledScriptPropertyStore)).tags("encoding", encoding).register(this.meterRegistry);
        Gauge.builder(COMPILED_HISTORY_GAUGE, () -> NashornCounterCollector.getCompiledScriptHistoryCount(compiledScriptPropertyStore)).tags("encoding", encoding).register(this.meterRegistry);
        if (counters.isPropertyMapStoreActive()) {
            Gauge.builder(BINDINGS_MAP_RETAINED_GAUGE, counters.getBindingsPropertyMaps()::count).tags("encoding", encoding).register(this.meterRegistry);
        }
    }

    public static JsDecodingMetricsBuilder builder() {
        return new JsDecodingMetricsBuilder();
    }

    public Map<String, SamplingNashornPropertyMapStore> getSampledPropertyMaps() {
        return this.sampledPropertyMaps;
    }

    public Map<String, NashornPropertyMapStore> getCompiledScriptPropertyMaps() {
        return this.compiledScriptPropertyMaps;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public int getMaxScriptDepth() {
        return this.maxScriptDepth;
    }

    public int getReferencesCollectPeriodMs() {
        return this.referencesCollectPeriodMs;
    }

    public int getReferencesClearLimit() {
        return this.referencesClearLimit;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void setMaxScriptDepth(int maxScriptDepth) {
        this.maxScriptDepth = maxScriptDepth;
    }

    public void setReferencesCollectPeriodMs(int referencesCollectPeriodMs) {
        this.referencesCollectPeriodMs = referencesCollectPeriodMs;
    }

    public void setReferencesClearLimit(int referencesClearLimit) {
        this.referencesClearLimit = referencesClearLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsDecodingMetrics)) {
            return false;
        }
        JsDecodingMetrics other = (JsDecodingMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxScriptDepth() != other.getMaxScriptDepth()) {
            return false;
        }
        if (this.getReferencesCollectPeriodMs() != other.getReferencesCollectPeriodMs()) {
            return false;
        }
        if (this.getReferencesClearLimit() != other.getReferencesClearLimit()) {
            return false;
        }
        Map<String, SamplingNashornPropertyMapStore> this$sampledPropertyMaps = this.getSampledPropertyMaps();
        Map<String, SamplingNashornPropertyMapStore> other$sampledPropertyMaps = other.getSampledPropertyMaps();
        if (this$sampledPropertyMaps == null ? other$sampledPropertyMaps != null : !((Object)this$sampledPropertyMaps).equals(other$sampledPropertyMaps)) {
            return false;
        }
        Map<String, NashornPropertyMapStore> this$compiledScriptPropertyMaps = this.getCompiledScriptPropertyMaps();
        Map<String, NashornPropertyMapStore> other$compiledScriptPropertyMaps = other.getCompiledScriptPropertyMaps();
        if (this$compiledScriptPropertyMaps == null ? other$compiledScriptPropertyMaps != null : !((Object)this$compiledScriptPropertyMaps).equals(other$compiledScriptPropertyMaps)) {
            return false;
        }
        MeterRegistry this$meterRegistry = this.getMeterRegistry();
        MeterRegistry other$meterRegistry = other.getMeterRegistry();
        return !(this$meterRegistry == null ? other$meterRegistry != null : !this$meterRegistry.equals(other$meterRegistry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsDecodingMetrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxScriptDepth();
        result = result * 59 + this.getReferencesCollectPeriodMs();
        result = result * 59 + this.getReferencesClearLimit();
        Map<String, SamplingNashornPropertyMapStore> $sampledPropertyMaps = this.getSampledPropertyMaps();
        result = result * 59 + ($sampledPropertyMaps == null ? 43 : ((Object)$sampledPropertyMaps).hashCode());
        Map<String, NashornPropertyMapStore> $compiledScriptPropertyMaps = this.getCompiledScriptPropertyMaps();
        result = result * 59 + ($compiledScriptPropertyMaps == null ? 43 : ((Object)$compiledScriptPropertyMaps).hashCode());
        MeterRegistry $meterRegistry = this.getMeterRegistry();
        result = result * 59 + ($meterRegistry == null ? 43 : $meterRegistry.hashCode());
        return result;
    }

    public String toString() {
        return "JsDecodingMetrics(sampledPropertyMaps=" + this.getSampledPropertyMaps() + ", compiledScriptPropertyMaps=" + this.getCompiledScriptPropertyMaps() + ", meterRegistry=" + this.getMeterRegistry() + ", maxScriptDepth=" + this.getMaxScriptDepth() + ", referencesCollectPeriodMs=" + this.getReferencesCollectPeriodMs() + ", referencesClearLimit=" + this.getReferencesClearLimit() + ")";
    }

    public JsDecodingMetrics() {
    }

    public JsDecodingMetrics(MeterRegistry meterRegistry, int maxScriptDepth, int referencesCollectPeriodMs, int referencesClearLimit) {
        this.meterRegistry = meterRegistry;
        this.maxScriptDepth = maxScriptDepth;
        this.referencesCollectPeriodMs = referencesCollectPeriodMs;
        this.referencesClearLimit = referencesClearLimit;
    }

    public static class JsDecodingMetricsBuilder {
        private MeterRegistry meterRegistry;
        private int maxScriptDepth;
        private int referencesCollectPeriodMs;
        private int referencesClearLimit;

        JsDecodingMetricsBuilder() {
        }

        public JsDecodingMetricsBuilder meterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
            return this;
        }

        public JsDecodingMetricsBuilder maxScriptDepth(int maxScriptDepth) {
            this.maxScriptDepth = maxScriptDepth;
            return this;
        }

        public JsDecodingMetricsBuilder referencesCollectPeriodMs(int referencesCollectPeriodMs) {
            this.referencesCollectPeriodMs = referencesCollectPeriodMs;
            return this;
        }

        public JsDecodingMetricsBuilder referencesClearLimit(int referencesClearLimit) {
            this.referencesClearLimit = referencesClearLimit;
            return this;
        }

        public JsDecodingMetrics build() {
            return new JsDecodingMetrics(this.meterRegistry, this.maxScriptDepth, this.referencesCollectPeriodMs, this.referencesClearLimit);
        }

        public String toString() {
            return "JsDecodingMetrics.JsDecodingMetricsBuilder(meterRegistry=" + this.meterRegistry + ", maxScriptDepth=" + this.maxScriptDepth + ", referencesCollectPeriodMs=" + this.referencesCollectPeriodMs + ", referencesClearLimit=" + this.referencesClearLimit + ")";
        }
    }
}

