/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js;

import com.orange.decoder.exception.js.JsDecodingException;
import com.orange.decoder.js.JsDecodingTask;
import com.orange.iaes.utils.MarkerUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsDecodingTaskRunner {
    private static final Logger log = LoggerFactory.getLogger(JsDecodingTaskRunner.class);
    private static final int JS_TIMEOUT_VALUE = 5000;
    private static ExecutorService pool = Executors.newFixedThreadPool(20);

    public static String runJSDecodingTask(JsDecodingTask task) throws JsDecodingException {
        try {
            return JsDecodingTaskRunner.processJSDecodingTask(task);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JsDecodingException) {
                log.debug("Error during JS execution :{} ", (Object)e.getMessage());
                throw new JsDecodingException("Error during JS execution : " + e.getMessage(), e);
            }
            if (JsDecodingTaskRunner.isStackOverflowError(e)) {
                log.info(MarkerUtils.warnDev(), "Stackoverflow while decoding message : script is too complex.");
                throw new JsDecodingException("Decoder is too complex and requires too much memory. Please update the decoder to decrease its memory consumption.");
            }
            log.warn("Unexpected exception during js execution :{} ", e);
            throw new JsDecodingException("Unexpected exception during js execution : " + e.getMessage(), e);
        }
        catch (TimeoutException e) {
            log.warn("Timeout on JS decoding");
            throw new JsDecodingException("Timeout on JS decoding", e);
        }
        catch (InterruptedException e) {
            log.info("JsDecoding interrupted : {}", e);
            Thread.currentThread().interrupt();
            throw new JsDecodingException("JsDecoding interrupted : " + e.getMessage(), e);
        }
    }

    private static boolean isStackOverflowError(ExecutionException e) {
        return ExceptionUtils.indexOfType(e, StackOverflowError.class) != -1;
    }

    private static String processJSDecodingTask(JsDecodingTask task) throws InterruptedException, ExecutionException, TimeoutException {
        String decoded = null;
        Future<String> scriptTask = pool.submit(task);
        try {
            decoded = scriptTask.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            scriptTask.cancel(true);
            throw e;
        }
        return decoded;
    }
}

