/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js;

import com.orange.decoder.exception.js.JsDecodingException;
import com.orange.decoder.js.metrics.JsDecodingMetrics;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsDecodingTask
implements Callable<String> {
    private static final Logger log = LoggerFactory.getLogger(JsDecodingTask.class);
    private final String entryPointFunction;
    private final NashornScriptEngine scriptEngine;
    private final JsDecodingMetrics scriptMetrics;
    private final CompiledScript script;
    private final String[] taskArguments;
    private final String encoding;

    public JsDecodingTask(String entryPointFunction, NashornScriptEngine scriptEngine, JsDecodingMetrics scriptMetrics, String encoding, CompiledScript script, String ... taskArguments) {
        this.entryPointFunction = entryPointFunction;
        this.scriptEngine = scriptEngine;
        this.scriptMetrics = scriptMetrics;
        this.encoding = encoding;
        this.script = script;
        this.taskArguments = taskArguments;
    }

    @Override
    public String call() throws JsDecodingException {
        String decoded;
        block5: {
            decoded = null;
            try {
                Bindings bindings = this.scriptEngine.createBindings();
                this.script.eval(bindings);
                ScriptObjectMirror scriptObjectMirror = (ScriptObjectMirror)bindings.get(this.entryPointFunction);
                if (scriptObjectMirror != null) {
                    decoded = (String)scriptObjectMirror.call(null, (Object[])this.taskArguments);
                    if (this.scriptMetrics != null) {
                        this.scriptMetrics.increment(this.script, bindings, this.encoding);
                    }
                    break block5;
                }
                throw new JsDecodingException(String.format("The decoding entry point function cannot be found. It must be named: %s", this.entryPointFunction));
            }
            catch (ScriptException e) {
                log.debug("Error during js script execution :{} ", (Object)e.getMessage());
                throw new JsDecodingException("Error during js script execution : " + e.getMessage(), e);
            }
            catch (RuntimeException e) {
                throw new JsDecodingException(e.getCause());
            }
        }
        log.debug("decoded : {}", (Object)decoded);
        return decoded;
    }
}

