/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.js;

import com.orange.decoder.exception.js.JsDecoderBuildingException;
import com.orange.decoder.js.metrics.JsDecodingMetrics;
import com.orange.decoder.js.simple.JsDecoder;
import com.orange.decoder.js.split.JsSplitDecoder;
import com.orange.iaes.datazone.resources.ResourcesListing;
import java.io.IOException;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsDecoderFactory {
    private static final Logger log = LoggerFactory.getLogger(JsDecoderFactory.class);
    private static final ResourcesListing JS_LIB_RESOURCES = new ResourcesListing("javascript/", ".js");

    public static JsDecoder buildDefaultDecoder(String jsScript) throws JsDecoderBuildingException {
        return JsDecoderFactory.buildDecoder(jsScript, "", true, null);
    }

    public static JsDecoder buildDefaultDecoder(String jsScript, JsDecodingMetrics jsDecodingMetrics) throws JsDecoderBuildingException {
        return JsDecoderFactory.buildDecoder(jsScript, "", true, jsDecodingMetrics);
    }

    public static JsDecoder buildDecoder(String jsScript, String template, Boolean mathEvalEnabled, JsDecodingMetrics jsDecodingMetrics) throws JsDecoderBuildingException {
        CompiledScriptEngine compiledScriptEngine = JsDecoderFactory.buildCompiledScriptEngine(jsScript);
        return new JsDecoder(compiledScriptEngine.getEngine(), template, mathEvalEnabled, compiledScriptEngine.getCompiledScript(), jsDecodingMetrics);
    }

    public static JsDecoder buildDecoder(String jsScript, String template, Boolean mathEvalEnabled) throws JsDecoderBuildingException {
        return JsDecoderFactory.buildDecoder(jsScript, template, mathEvalEnabled, null);
    }

    public static JsSplitDecoder buildSplitDecoder(String jsSplitScript, JsDecodingMetrics jsDecodingMetrics) throws JsDecoderBuildingException {
        CompiledScriptEngine compiledScriptEngine = JsDecoderFactory.buildCompiledScriptEngine(jsSplitScript);
        return new JsSplitDecoder(compiledScriptEngine.getEngine(), compiledScriptEngine.getCompiledScript(), jsDecodingMetrics);
    }

    public static JsSplitDecoder buildSplitDecoder(String jsSplitScript) throws JsDecoderBuildingException {
        CompiledScriptEngine compiledScriptEngine = JsDecoderFactory.buildCompiledScriptEngine(jsSplitScript);
        return new JsSplitDecoder(compiledScriptEngine.getEngine(), compiledScriptEngine.getCompiledScript(), null);
    }

    private static CompiledScriptEngine buildCompiledScriptEngine(String decodingScript) throws JsDecoderBuildingException {
        ScriptEngineManager factory = new ScriptEngineManager();
        NashornScriptEngine engine = (NashornScriptEngine)factory.getEngineByName("nashorn");
        StringBuilder predefinedScripts = new StringBuilder();
        try {
            for (String js : JS_LIB_RESOURCES.getResourcesNames()) {
                predefinedScripts.append(JS_LIB_RESOURCES.getRawResourceContent(js));
            }
            predefinedScripts.append(decodingScript);
            return new CompiledScriptEngine(engine, engine.compile(predefinedScripts.toString()));
        }
        catch (IOException | ScriptException e) {
            log.debug("Error during JS decoder building :{} ", (Object)e.getMessage());
            throw new JsDecoderBuildingException("Error during JS decoder building : " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.warn("Unexpected exception during JS decoder building :{} ", (Object)e.getMessage());
            throw new JsDecoderBuildingException("Unexpected exception during JS decoder building : " + e.getMessage(), e);
        }
    }

    private JsDecoderFactory() {
    }

    static {
        try {
            JS_LIB_RESOURCES.buildList();
        }
        catch (IOException e) {
            log.error("Can not build js lib resources list");
        }
    }

    public static class CompiledScriptEngine {
        private NashornScriptEngine engine;
        private CompiledScript compiledScript;

        public NashornScriptEngine getEngine() {
            return this.engine;
        }

        public CompiledScript getCompiledScript() {
            return this.compiledScript;
        }

        public void setEngine(NashornScriptEngine engine) {
            this.engine = engine;
        }

        public void setCompiledScript(CompiledScript compiledScript) {
            this.compiledScript = compiledScript;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompiledScriptEngine)) {
                return false;
            }
            CompiledScriptEngine other = (CompiledScriptEngine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NashornScriptEngine this$engine = this.getEngine();
            NashornScriptEngine other$engine = other.getEngine();
            if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
                return false;
            }
            CompiledScript this$compiledScript = this.getCompiledScript();
            CompiledScript other$compiledScript = other.getCompiledScript();
            return !(this$compiledScript == null ? other$compiledScript != null : !this$compiledScript.equals(other$compiledScript));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CompiledScriptEngine;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NashornScriptEngine $engine = this.getEngine();
            result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
            CompiledScript $compiledScript = this.getCompiledScript();
            result = result * 59 + ($compiledScript == null ? 43 : $compiledScript.hashCode());
            return result;
        }

        public String toString() {
            return "JsDecoderFactory.CompiledScriptEngine(engine=" + this.getEngine() + ", compiledScript=" + this.getCompiledScript() + ")";
        }

        public CompiledScriptEngine(NashornScriptEngine engine, CompiledScript compiledScript) {
            this.engine = engine;
            this.compiledScript = compiledScript;
        }
    }
}

