/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.csv;

import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.orange.decoder.csv.CSVcolumnsDescription;
import com.orange.decoder.csv.CsvDecoder;
import com.orange.decoder.csv.CsvDecodingOptions;
import com.orange.decoder.exception.csv.CsvDecoderBuildingException;
import java.util.ArrayList;

public class CsvDecoderFactory {
    public static CsvDecoder buildDecoder(CSVcolumnsDescription columnsDescription, CsvDecodingOptions options) throws CsvDecoderBuildingException {
        return CsvDecoderFactory.buildDecoder(columnsDescription, options, null, true);
    }

    public static CsvDecoder buildDecoder(CSVcolumnsDescription columnsDescription, CsvDecodingOptions options, String model, String template) throws CsvDecoderBuildingException {
        return CsvDecoderFactory.buildDecoder(columnsDescription, options, template, true);
    }

    public static CsvDecoder buildDecoder(CSVcolumnsDescription columnsDescription, CsvDecodingOptions options, String template, Boolean mathEvalEnabled) throws CsvDecoderBuildingException {
        ArrayList<String> columnsAsNumbers = new ArrayList<String>();
        ArrayList<String> columnsAsBoolean = new ArrayList<String>();
        CsvSchema csvSchema = CsvDecoderFactory.buildSchema(columnsDescription, options);
        block5: for (CSVcolumnsDescription.Column col : columnsDescription.getColumns()) {
            switch (col.getType()) {
                case NUMERIC: {
                    columnsAsNumbers.add(col.getName());
                    continue block5;
                }
                case BOOLEAN: {
                    columnsAsBoolean.add(col.getName());
                    continue block5;
                }
                case STRING: {
                    continue block5;
                }
            }
            throw new CsvDecoderBuildingException("Unknown column type : " + (Object)((Object)col.getType()));
        }
        return new CsvDecoder(csvSchema, columnsAsNumbers, columnsAsBoolean, options.isSkipWhiteSpace(), template, mathEvalEnabled);
    }

    private static CsvSchema buildSchema(CSVcolumnsDescription columnsDescription, CsvDecodingOptions options) {
        CsvSchema.Builder csvSchemaBuilder = CsvSchema.builder().setColumnSeparator(options.getColumnSeparator());
        csvSchemaBuilder.setNullValue(options.getNullValue());
        csvSchemaBuilder.setUseHeader(options.isUseHeader());
        if (options.isUseEscapeChar()) {
            csvSchemaBuilder.setEscapeChar(options.getEscapeChar());
        } else {
            csvSchemaBuilder.disableEscapeChar();
        }
        csvSchemaBuilder.setLineSeparator(options.getLineFeedSeparator());
        csvSchemaBuilder.setQuoteChar(options.getQuoteChar());
        columnsDescription.getColumns().forEach(col -> {
            CsvSchema.ColumnType type = col.getType() == CSVcolumnsDescription.JSONType.NUMERIC ? CsvSchema.ColumnType.NUMBER : CsvSchema.ColumnType.STRING;
            csvSchemaBuilder.addColumn(col.getName(), type);
        });
        return csvSchemaBuilder.build();
    }
}

