/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.csv;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.orange.decoder.exception.DecodingException;
import com.orange.decoder.exception.csv.CsvParsingException;
import com.orange.decoder.simple.SimpleDecoder;
import com.orange.decoder.simple.SimpleDecoderResult;
import com.orange.iaes.commons.json.JsonEncodingException;
import com.orange.iaes.commons.json.JsonUtils;
import java.util.HashMap;
import java.util.List;

public class CsvDecoder
extends SimpleDecoder {
    ObjectReader reader;
    List<String> columnsAsNumbers;
    List<String> columnsAsBoolean;
    boolean skipWhiteSpace;

    protected CsvDecoder(CsvSchema schema, List<String> columnsAsNumbers, List<String> columnsAsBoolean, boolean skipWhiteSpace, String template, Boolean mathEvalEnabled) {
        super(template, mathEvalEnabled);
        this.reader = new CsvMapper().reader(schema).forType(HashMap.class);
        this.columnsAsBoolean = columnsAsBoolean;
        this.columnsAsNumbers = columnsAsNumbers;
        this.skipWhiteSpace = skipWhiteSpace;
    }

    @Override
    public SimpleDecoderResult decode(String encodedValue, Object encodedDataMessage) throws DecodingException {
        return this.csvDecoding(encodedValue);
    }

    public final String toJson(String encodedValue) throws DecodingException {
        return this.toJson(encodedValue, null);
    }

    public SimpleDecoderResult csvDecoding(String encodedValue) throws CsvParsingException {
        JsonObject jsonDecoded;
        HashMap readValue = null;
        try {
            readValue = (HashMap)this.reader.readValue(encodedValue);
            if (this.skipWhiteSpace) {
                readValue.replaceAll((k, v) -> ((String)v).trim());
            }
            readValue.replaceAll((k, v) -> this.convertString(this.columnsAsNumbers, (String)k, v));
            readValue.replaceAll((k, v) -> this.columnsAsBoolean.contains(k) ? Boolean.valueOf(Boolean.parseBoolean((String)v)) : v);
        }
        catch (NumberFormatException e) {
            throw new CsvParsingException("Numeric value parsing failed :  " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CsvParsingException("CSV parsing exception : " + e.getMessage(), e);
        }
        try {
            jsonDecoded = JsonParser.parseString(JsonUtils.encode(readValue)).getAsJsonObject();
        }
        catch (JsonEncodingException e) {
            throw new CsvParsingException("CSV Decoding exception : " + e.getMessage(), e);
        }
        return this.applyOutputTemplate(jsonDecoded);
    }

    private Object convertString(List<String> columnsAsNumbers, String k, Object v) {
        if (columnsAsNumbers.contains(k)) {
            try {
                return Integer.parseInt((String)v);
            }
            catch (NumberFormatException e) {
                try {
                    return Double.parseDouble((String)v);
                }
                catch (NullPointerException ex) {
                    return null;
                }
            }
        }
        return v;
    }
}

