/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.orange.decoder.binary.JBBPFieldArrayUTF8Char;
import com.orange.decoder.binary.JBBPFieldUTF8Char;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class UTF8CustomTypeProcessor
implements JBBPCustomFieldTypeProcessor {
    private static final String[] TYPES = new String[]{"utf8", "UTF8"};

    @Override
    public String[] getCustomFieldTypes() {
        return TYPES;
    }

    @Override
    public boolean isAllowed(JBBPFieldTypeParameterContainer fieldType, String fieldName, int extraData, boolean isArray) {
        return extraData == 0;
    }

    @Override
    public JBBPAbstractField readCustomFieldType(JBBPBitInputStream in, JBBPBitOrder bitOrder, int parserFlags, JBBPFieldTypeParameterContainer customTypeFieldInfo, JBBPNamedFieldInfo fieldName, int extraData, boolean readWholeStream, int arrayLength) throws IOException {
        if (arrayLength < 0) {
            return new JBBPFieldUTF8Char(fieldName, UTF8CustomTypeProcessor.readBytesAsUTF8Char(in));
        }
        if (readWholeStream) {
            CharBuffer charBuffer = new CharBuffer(1024);
            while (in.hasAvailableData()) {
                charBuffer.put(UTF8CustomTypeProcessor.readBytesAsUTF8Char(in));
            }
            return new JBBPFieldArrayUTF8Char(fieldName, charBuffer.toArray());
        }
        char[] array = new char[arrayLength];
        UTF8CustomTypeProcessor.readBytesAsUTF8Array(in, array);
        return new JBBPFieldArrayUTF8Char(fieldName, array);
    }

    private static void readBytesAsUTF8Array(JBBPBitInputStream in, char[] array) throws IOException {
        in.mark(in.available() + 1);
        CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.IGNORE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        InputStreamReader reader = new InputStreamReader((InputStream)in, charsetDecoder);
        int res = reader.read(array);
        if (res < array.length) {
            throw new EOFException("Can't read enough UTF-8 character values");
        }
        in.reset();
        in.skip(new String(array).getBytes(StandardCharsets.UTF_8).length);
    }

    private static char readBytesAsUTF8Char(JBBPBitInputStream in) throws IOException {
        in.mark(in.available() + 1);
        CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.IGNORE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        InputStreamReader reader = new InputStreamReader((InputStream)in, charsetDecoder);
        int res = reader.read();
        if (res < 0) {
            throw new EOFException("Can't read an UTF-8 character value");
        }
        in.reset();
        in.skip(String.valueOf((char)res).getBytes(StandardCharsets.UTF_8).length);
        return (char)res;
    }

    private static final class CharBuffer {
        private char[] buffer;
        private int freePos;

        public CharBuffer(int initialCapacity) {
            this.buffer = new char[Math.max(4, initialCapacity)];
        }

        public CharBuffer put(char value) {
            if (this.freePos == this.buffer.length) {
                char[] newbuffer = new char[this.buffer.length * 3 / 2];
                System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
                this.buffer = newbuffer;
            }
            this.buffer[this.freePos++] = value;
            return this;
        }

        public char[] toArray() {
            return Arrays.copyOf(this.buffer, this.freePos);
        }
    }
}

