/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldDouble
extends JBBPAbstractField
implements JBBPNumericField {
    private static final long serialVersionUID = -731609546766687161L;
    private final long value;

    public JBBPFieldDouble(JBBPNamedFieldInfo name, long value) {
        super(name);
        this.value = value;
    }

    @Override
    public int getAsInt() {
        return (int)this.value;
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public boolean getAsBool() {
        return this.value != 0L;
    }

    public double getAsDouble() {
        return Double.longBitsToDouble(this.value);
    }

    public static long reverseBits(long value) {
        long b0 = (long)JBBPUtils.reverseBitsInByte((byte)value) & 0xFFL;
        long b1 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 8)) & 0xFFL;
        long b2 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 16)) & 0xFFL;
        long b3 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 24)) & 0xFFL;
        long b4 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 32)) & 0xFFL;
        long b5 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 40)) & 0xFFL;
        long b6 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 48)) & 0xFFL;
        long b7 = (long)JBBPUtils.reverseBitsInByte((byte)(value >> 56)) & 0xFFL;
        return b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7;
    }

    @Override
    public long getAsInvertedBitOrder() {
        return JBBPFieldDouble.reverseBits(this.value);
    }

    @Override
    public String getTypeAsString() {
        return "double";
    }
}

