/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.orange.decoder.binary.JBBPFieldFloat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class JBBPFieldArrayFloat
extends JBBPAbstractArrayField<JBBPFieldFloat> {
    private static final long serialVersionUID = 6839868800303265190L;
    private final int[] array;

    public JBBPFieldArrayFloat(JBBPNamedFieldInfo name, int[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public Float[] getArray() {
        List<Float> transformed = Arrays.stream(this.array).boxed().map(x -> Float.valueOf(Float.intBitsToFloat(x))).collect(Collectors.toList());
        return transformed.toArray(new Float[transformed.size()]);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldFloat getElementAt(int index) {
        JBBPFieldFloat result = new JBBPFieldFloat(this.fieldNameInfo, this.array[index]);
        result.setPayload(this.payload);
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return this.array[index];
    }

    @Override
    public long getAsLong(int index) {
        return this.getAsInt(index);
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index] != 0;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        int[] result;
        if (reverseBits) {
            result = (int[])this.array.clone();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (int)JBBPFieldInt.reverseBits(result[i]);
            }
        } else {
            result = (int[])this.array.clone();
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "float [" + this.array.length + ']';
    }
}

