/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.orange.decoder.binary.JBBPFieldDouble;

public final class JBBPFieldArrayDouble
extends JBBPAbstractArrayField<JBBPFieldDouble> {
    private static final long serialVersionUID = 3036577808792632901L;
    private final long[] array;

    public JBBPFieldArrayDouble(JBBPNamedFieldInfo name, long[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public double[] getArray() {
        double[] result = new double[this.array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.longBitsToDouble(this.array[i]);
        }
        return result;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldDouble getElementAt(int index) {
        JBBPFieldDouble result = new JBBPFieldDouble(this.fieldNameInfo, this.array[index]);
        result.setPayload(this.payload);
        return result;
    }

    public double getAsDouble(int index) {
        return Double.longBitsToDouble(this.array[index]);
    }

    @Override
    public int getAsInt(int index) {
        return (int)this.array[index];
    }

    @Override
    public long getAsLong(int index) {
        return this.getAsInt(index);
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index] != 0L;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        double[] result = new double[this.array.length];
        if (reverseBits) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = Double.longBitsToDouble(JBBPFieldLong.reverseBits(this.array[i]));
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                result[i] = Double.longBitsToDouble(this.array[i]);
            }
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "double [" + this.array.length + ']';
    }
}

