/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.orange.decoder.binary.JBBPFieldArrayFloat;
import com.orange.decoder.binary.JBBPFieldFloat;
import java.io.IOException;
import java.util.Arrays;

public final class Float32CustomTypeProcessor
implements JBBPCustomFieldTypeProcessor {
    private static final String[] TYPES = new String[]{"float"};

    @Override
    public String[] getCustomFieldTypes() {
        return TYPES;
    }

    @Override
    public boolean isAllowed(JBBPFieldTypeParameterContainer fieldType, String fieldName, int extraData, boolean isArray) {
        return extraData == 0;
    }

    @Override
    public JBBPAbstractField readCustomFieldType(JBBPBitInputStream in, JBBPBitOrder bitOrder, int parserFlags, JBBPFieldTypeParameterContainer customTypeFieldInfo, JBBPNamedFieldInfo fieldName, int extraData, boolean readWholeStream, int arrayLength) throws IOException {
        if (arrayLength < 0) {
            return new JBBPFieldFloat(fieldName, Float32CustomTypeProcessor.readFourBytesAsInt(in, customTypeFieldInfo.getByteOrder(), bitOrder));
        }
        if (readWholeStream) {
            IntBuffer intBuffer = new IntBuffer(1024);
            while (in.hasAvailableData()) {
                intBuffer.put(Float32CustomTypeProcessor.readFourBytesAsInt(in, customTypeFieldInfo.getByteOrder(), bitOrder));
            }
            return new JBBPFieldArrayFloat(fieldName, intBuffer.toArray());
        }
        int[] array = new int[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = Float32CustomTypeProcessor.readFourBytesAsInt(in, customTypeFieldInfo.getByteOrder(), bitOrder);
        }
        return new JBBPFieldArrayFloat(fieldName, array);
    }

    private static int readFourBytesAsInt(JBBPBitInputStream in, JBBPByteOrder byteOrder, JBBPBitOrder bitOrder) throws IOException {
        int b0 = in.readByte();
        int b1 = in.readByte();
        int b2 = in.readByte();
        int b3 = in.readByte();
        int value = byteOrder == JBBPByteOrder.BIG_ENDIAN ? b0 << 24 | b1 << 16 | b2 << 8 | b3 : b3 << 24 | b2 << 16 | b1 << 8 | b0;
        return bitOrder == JBBPBitOrder.LSB0 ? value : (int)JBBPFieldInt.reverseBits(value) >>> 8;
    }

    private static final class IntBuffer {
        private int[] buffer;
        private int freePos;

        public IntBuffer(int initialCapacity) {
            this.buffer = new int[Math.max(4, initialCapacity)];
        }

        public IntBuffer put(int value) {
            if (this.freePos == this.buffer.length) {
                int[] newbuffer = new int[this.buffer.length * 3 / 2];
                System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
                this.buffer = newbuffer;
            }
            this.buffer[this.freePos++] = value;
            return this;
        }

        public int[] toArray() {
            return Arrays.copyOf(this.buffer, this.freePos);
        }
    }
}

