/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.orange.decoder.binary.JBBPFieldArrayDouble;
import com.orange.decoder.binary.JBBPFieldDouble;
import java.io.IOException;
import java.util.Arrays;

public final class Double64CustomTypeProcessor
implements JBBPCustomFieldTypeProcessor {
    private static final String[] TYPES = new String[]{"double"};

    @Override
    public String[] getCustomFieldTypes() {
        return TYPES;
    }

    @Override
    public boolean isAllowed(JBBPFieldTypeParameterContainer fieldType, String fieldName, int extraData, boolean isArray) {
        return extraData == 0;
    }

    @Override
    public JBBPAbstractField readCustomFieldType(JBBPBitInputStream in, JBBPBitOrder bitOrder, int parserFlags, JBBPFieldTypeParameterContainer customTypeFieldInfo, JBBPNamedFieldInfo fieldName, int extraData, boolean readWholeStream, int arrayLength) throws IOException {
        if (arrayLength < 0) {
            return new JBBPFieldDouble(fieldName, Double64CustomTypeProcessor.readEightBytesAsLong(in, customTypeFieldInfo.getByteOrder(), bitOrder));
        }
        if (readWholeStream) {
            LongBuffer longBuffer = new LongBuffer(1024);
            while (in.hasAvailableData()) {
                longBuffer.put(Double64CustomTypeProcessor.readEightBytesAsLong(in, customTypeFieldInfo.getByteOrder(), bitOrder));
            }
            return new JBBPFieldArrayDouble(fieldName, longBuffer.toArray());
        }
        long[] array = new long[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = Double64CustomTypeProcessor.readEightBytesAsLong(in, customTypeFieldInfo.getByteOrder(), bitOrder);
        }
        return new JBBPFieldArrayDouble(fieldName, array);
    }

    private static long readEightBytesAsLong(JBBPBitInputStream in, JBBPByteOrder byteOrder, JBBPBitOrder bitOrder) throws IOException {
        long l1 = (long)in.readInt(byteOrder) & 0xFFFFFFFFL;
        long l2 = (long)in.readInt(byteOrder) & 0xFFFFFFFFL;
        long result = byteOrder == JBBPByteOrder.BIG_ENDIAN ? l1 << 32 | l2 : l1 | l2 << 32;
        return bitOrder == JBBPBitOrder.LSB0 ? result : JBBPFieldLong.reverseBits(result);
    }

    private static final class LongBuffer {
        private long[] buffer;
        private int freePos;

        public LongBuffer(int initialCapacity) {
            this.buffer = new long[Math.max(8, initialCapacity)];
        }

        public LongBuffer put(long value) {
            if (this.freePos == this.buffer.length) {
                long[] newbuffer = new long[this.buffer.length * 3 / 2];
                System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
                this.buffer = newbuffer;
            }
            this.buffer[this.freePos++] = value;
            return this;
        }

        public long[] toArray() {
            return Arrays.copyOf(this.buffer, this.freePos);
        }
    }
}

