/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.exceptions.JBBPCompilationException;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.utils.JBBPCustomFieldTypeProcessorAggregator;
import com.orange.decoder.binary.AsciiCharCustomTypeProcessor;
import com.orange.decoder.binary.BinaryDecoder;
import com.orange.decoder.binary.BinaryDecodingOptions;
import com.orange.decoder.binary.Double64CustomTypeProcessor;
import com.orange.decoder.binary.Float32CustomTypeProcessor;
import com.orange.decoder.binary.UTF8CustomTypeProcessor;
import com.orange.decoder.exceptions.binary.BinaryDecoderBuildingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoderFactory {
    private static final Logger log = LoggerFactory.getLogger(BinaryDecoderFactory.class);

    public static BinaryDecoder buildDecoder(String encodingFormat, BinaryDecodingOptions options) throws BinaryDecoderBuildingException {
        return BinaryDecoderFactory.buildDecoder(encodingFormat, options, null, true);
    }

    public static BinaryDecoder buildDefaultDecoder(String encodingFormat) throws BinaryDecoderBuildingException {
        return BinaryDecoderFactory.buildDefaultDecoder(encodingFormat, null, true);
    }

    public static BinaryDecoder buildDefaultDecoder(String encodingFormat, String template) throws BinaryDecoderBuildingException {
        return BinaryDecoderFactory.buildDefaultDecoder(encodingFormat, template, true);
    }

    public static BinaryDecoder buildDefaultDecoder(String encodingFormat, String template, Boolean mathEvalEnabled) throws BinaryDecoderBuildingException {
        BinaryDecodingOptions defaultOptions = BinaryDecodingOptions.builder().acceptPartialParsing(false).LSB(true).build();
        return BinaryDecoderFactory.buildDecoder(encodingFormat, defaultOptions, template, mathEvalEnabled);
    }

    public static BinaryDecoder buildDecoder(String encodingFormat, BinaryDecodingOptions options, String template, Boolean mathEvalEnabled) throws BinaryDecoderBuildingException {
        if (StringUtils.isEmpty(encodingFormat)) {
            throw new BinaryDecoderBuildingException("Empty encoding format");
        }
        int flags = options.isAcceptPartialParsing() ? 1 : 0;
        JBBPBitOrder bitOrder = options.isLSB() ? JBBPBitOrder.LSB0 : JBBPBitOrder.MSB0;
        try {
            JBBPParser parser = JBBPParser.prepare(encodingFormat, bitOrder, new JBBPCustomFieldTypeProcessorAggregator(new AsciiCharCustomTypeProcessor(), new Float32CustomTypeProcessor(), new Double64CustomTypeProcessor(), new UTF8CustomTypeProcessor()), flags);
            return new BinaryDecoder(parser, template, mathEvalEnabled);
        }
        catch (JBBPCompilationException e) {
            throw new BinaryDecoderBuildingException("Wrong binary format : " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.info("Unexpected wrong binary format : '{}'", (Object)encodingFormat);
            throw new BinaryDecoderBuildingException("Wrong binary format");
        }
    }
}

