/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.exceptions.JBBPParsingException;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPFieldBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldByte;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldUShort;
import com.orange.decoder.binary.JBBPFieldArrayAsciiChar;
import com.orange.decoder.binary.JBBPFieldArrayDouble;
import com.orange.decoder.binary.JBBPFieldArrayFloat;
import com.orange.decoder.binary.JBBPFieldArrayUTF8Char;
import com.orange.decoder.binary.JBBPFieldAsciiChar;
import com.orange.decoder.binary.JBBPFieldDouble;
import com.orange.decoder.binary.JBBPFieldFloat;
import com.orange.decoder.binary.JBBPFieldUTF8Char;
import com.orange.decoder.exception.DecodingException;
import com.orange.decoder.exceptions.binary.BinaryParsingException;
import com.orange.decoder.simple.SimpleDecoder;
import com.orange.decoder.simple.SimpleDecoderResult;
import com.orange.iaes.utils.MarkerUtils;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoder
extends SimpleDecoder {
    private static final Logger log = LoggerFactory.getLogger(BinaryDecoder.class);
    private JBBPParser parser;

    protected BinaryDecoder(JBBPParser parser, String template, Boolean mathEvalEnabled) {
        super(template, mathEvalEnabled);
        this.parser = parser;
    }

    public final String toJson(String encodedValue) throws DecodingException {
        return this.toJson(encodedValue, null);
    }

    @Override
    public SimpleDecoderResult decode(String encodedValue, Object encodedDataMessage) throws DecodingException {
        try {
            return this.decode(DatatypeConverter.parseHexBinary((String)encodedValue));
        }
        catch (IllegalArgumentException e) {
            log.debug("Encoded value is not a valid hexa string :{} ", (Object)e.getMessage());
            throw new DecodingException("Illegal argument : " + e.getMessage(), e);
        }
    }

    protected SimpleDecoderResult decode(byte[] hexBinary) throws DecodingException {
        JBBPFieldStruct parseResult;
        try {
            parseResult = this.parser.parse(hexBinary);
        }
        catch (IOException e) {
            log.debug("Read error while parsing:{} ", (Object)e.getMessage());
            throw new DecodingException("Read error: " + e.getMessage(), e);
        }
        catch (JBBPParsingException | ArithmeticException | NullPointerException e) {
            log.debug("Error while parsing: {} ", (Object)e.getMessage());
            throw new BinaryParsingException("Parse error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.info(MarkerUtils.warnDev(), "Unexpected error while parsing '{}' - please contact a developer, that should not happen ! - : {}", (Object)hexBinary, (Object)e.getMessage());
            throw new BinaryParsingException("Parse error: " + e.getMessage(), e);
        }
        return this.applyOutputTemplate(this.convertToJson(null, parseResult));
    }

    private JsonObject convertToJson(JsonObject jsn, JBBPAbstractField field) throws DecodingException {
        String fieldName;
        JsonObject json = jsn == null ? new JsonObject() : jsn;
        String string = fieldName = StringUtils.isEmpty(field.getFieldName()) ? "value" : field.getFieldName();
        if (field instanceof JBBPAbstractArrayField) {
            JsonArray jsonArray = new JsonArray();
            if (field instanceof JBBPFieldArrayBit) {
                for (byte b : ((JBBPFieldArrayBit)field).getArray()) {
                    jsonArray.add(b);
                }
            } else if (field instanceof JBBPFieldArrayBoolean) {
                for (boolean b : ((JBBPFieldArrayBoolean)field).getArray()) {
                    jsonArray.add(b);
                }
            } else if (field instanceof JBBPFieldArrayByte) {
                for (byte b : ((JBBPFieldArrayByte)field).getArray()) {
                    jsonArray.add(b);
                }
            } else if (field instanceof JBBPFieldArrayInt) {
                for (int b : ((JBBPFieldArrayInt)field).getArray()) {
                    jsonArray.add(b);
                }
            } else if (field instanceof JBBPFieldArrayFloat) {
                Float[] floatArray = ((JBBPFieldArrayFloat)field).getArray();
                int n = floatArray.length;
                for (int i = 0; i < n; ++i) {
                    float b = floatArray[i].floatValue();
                    jsonArray.add(Float.valueOf(b));
                }
            } else if (field instanceof JBBPFieldArrayDouble) {
                for (double b : ((JBBPFieldArrayDouble)field).getArray()) {
                    jsonArray.add(b);
                }
            } else {
                if (field instanceof JBBPFieldArrayAsciiChar) {
                    String result = "";
                    JBBPFieldArrayAsciiChar array = (JBBPFieldArrayAsciiChar)field;
                    for (int i = 0; i < array.size(); ++i) {
                        result = result + array.getElementAt(i).getAsString();
                    }
                    json.addProperty(fieldName, result);
                    return json;
                }
                if (field instanceof JBBPFieldArrayUTF8Char) {
                    String result = "";
                    JBBPFieldArrayUTF8Char array = (JBBPFieldArrayUTF8Char)field;
                    for (int i = 0; i < array.size(); ++i) {
                        result = result + array.getElementAt(i).getAsString();
                    }
                    json.addProperty(fieldName, result);
                    return json;
                }
                if (field instanceof JBBPFieldArrayLong) {
                    for (long b : ((JBBPFieldArrayLong)field).getArray()) {
                        jsonArray.add(b);
                    }
                } else if (field instanceof JBBPFieldArrayShort) {
                    for (short b : ((JBBPFieldArrayShort)field).getArray()) {
                        jsonArray.add(b);
                    }
                } else if (field instanceof JBBPFieldArrayStruct) {
                    JBBPFieldArrayStruct array = (JBBPFieldArrayStruct)field;
                    for (int i = 0; i < array.size(); ++i) {
                        jsonArray.add(this.convertToJson(new JsonObject(), array.getElementAt(i)));
                    }
                } else if (field instanceof JBBPFieldArrayUByte) {
                    for (byte b : ((JBBPFieldArrayUByte)field).getArray()) {
                        jsonArray.add(b & 0xFF);
                    }
                } else if (field instanceof JBBPFieldArrayUShort) {
                    for (short b : ((JBBPFieldArrayUShort)field).getArray()) {
                        jsonArray.add(b & 0xFFFF);
                    }
                } else {
                    throw new IllegalStateException("Unexpected field type");
                }
            }
            json.add(fieldName, jsonArray);
        } else if (field instanceof JBBPFieldBit) {
            json.addProperty(fieldName, ((JBBPFieldBit)field).getAsInt());
        } else if (field instanceof JBBPFieldFloat) {
            if (!Float.isFinite(((JBBPFieldFloat)field).getAsfloat())) {
                throw new DecodingException(((JBBPFieldFloat)field).getFieldName() + " is not finite");
            }
            json.addProperty(fieldName, Float.valueOf(((JBBPFieldFloat)field).getAsfloat()));
        } else if (field instanceof JBBPFieldDouble) {
            if (!Double.isFinite(((JBBPFieldDouble)field).getAsDouble())) {
                throw new DecodingException(((JBBPFieldDouble)field).getFieldName() + " is not finite");
            }
            json.addProperty(fieldName, ((JBBPFieldDouble)field).getAsDouble());
        } else if (field instanceof JBBPFieldAsciiChar) {
            json.addProperty(fieldName, ((JBBPFieldAsciiChar)field).getAsString());
        } else if (field instanceof JBBPFieldUTF8Char) {
            json.addProperty(fieldName, ((JBBPFieldUTF8Char)field).getAsString());
        } else if (field instanceof JBBPFieldBoolean) {
            json.addProperty(fieldName, ((JBBPFieldBoolean)field).getAsBool());
        } else if (field instanceof JBBPFieldByte) {
            json.addProperty(fieldName, ((JBBPFieldByte)field).getAsInt());
        } else if (field instanceof JBBPFieldInt) {
            json.addProperty(fieldName, ((JBBPFieldInt)field).getAsInt());
        } else if (field instanceof JBBPFieldLong) {
            json.addProperty(fieldName, ((JBBPFieldLong)field).getAsLong());
        } else if (field instanceof JBBPFieldShort) {
            json.addProperty(fieldName, ((JBBPFieldShort)field).getAsInt());
        } else if (field instanceof JBBPFieldStruct) {
            JBBPFieldStruct struct = (JBBPFieldStruct)field;
            for (JBBPAbstractField f : struct.getArray()) {
                this.convertToJson(json, f);
            }
        } else if (field instanceof JBBPFieldUByte) {
            json.addProperty(fieldName, ((JBBPFieldUByte)field).getAsInt());
        } else if (field instanceof JBBPFieldUShort) {
            json.addProperty(fieldName, ((JBBPFieldUShort)field).getAsInt());
        } else {
            throw new DecodingException("Unexpected field");
        }
        return json;
    }
}

