/*
 * Decompiled with CFR 0.152.
 */
package com.orange.decoder.binary;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.orange.decoder.binary.JBBPFieldArrayAsciiChar;
import com.orange.decoder.binary.JBBPFieldAsciiChar;
import java.io.IOException;
import java.util.Arrays;

public final class AsciiCharCustomTypeProcessor
implements JBBPCustomFieldTypeProcessor {
    private static final String[] TYPES = new String[]{"asciichar"};

    @Override
    public String[] getCustomFieldTypes() {
        return TYPES;
    }

    @Override
    public boolean isAllowed(JBBPFieldTypeParameterContainer fieldType, String fieldName, int extraData, boolean isArray) {
        return extraData == 0;
    }

    @Override
    public JBBPAbstractField readCustomFieldType(JBBPBitInputStream in, JBBPBitOrder bitOrder, int parserFlags, JBBPFieldTypeParameterContainer customTypeFieldInfo, JBBPNamedFieldInfo fieldName, int extraData, boolean readWholeStream, int arrayLength) throws IOException {
        if (arrayLength < 0) {
            return new JBBPFieldAsciiChar(fieldName, AsciiCharCustomTypeProcessor.readOneByte(in));
        }
        if (readWholeStream) {
            ByteBuffer intBuffer = new ByteBuffer(1024);
            while (in.hasAvailableData()) {
                intBuffer.put(AsciiCharCustomTypeProcessor.readOneByte(in));
            }
            return new JBBPFieldArrayAsciiChar(fieldName, intBuffer.toArray());
        }
        byte[] array = new byte[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = AsciiCharCustomTypeProcessor.readOneByte(in);
        }
        return new JBBPFieldArrayAsciiChar(fieldName, array);
    }

    private static byte readOneByte(JBBPBitInputStream in) throws IOException {
        return (byte)in.readByte();
    }

    private static final class ByteBuffer {
        private byte[] buffer;
        private int freePos;

        public ByteBuffer(int initialCapacity) {
            this.buffer = new byte[Math.max(4, initialCapacity)];
        }

        public ByteBuffer put(byte value) {
            if (this.freePos == this.buffer.length) {
                byte[] newbuffer = new byte[this.buffer.length * 3 / 2];
                System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
                this.buffer = newbuffer;
            }
            this.buffer[this.freePos++] = value;
            return this;
        }

        public byte[] toArray() {
            return Arrays.copyOf(this.buffer, this.freePos);
        }
    }
}

