/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.utils.JBBPIntCounter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPUtils {
    private static final Queue<PrivilegedProcessor> PROCESSORS_QUEUE = new ArrayBlockingQueue<PrivilegedProcessor>(32);

    private JBBPUtils() {
    }

    public static void makeAccessible(AccessibleObject obj) {
        if (obj != null) {
            PrivilegedProcessor processor = PROCESSORS_QUEUE.poll();
            if (processor == null) {
                processor = new PrivilegedProcessor();
            }
            processor.setAccessibleObject(obj);
            AccessController.doPrivileged(processor);
            PROCESSORS_QUEUE.offer(processor);
        }
    }

    public static boolean isNumber(String num) {
        if (num == null || num.length() == 0) {
            return false;
        }
        boolean firstIsDigit = Character.isDigit(num.charAt(0));
        if (!firstIsDigit && num.charAt(0) != '-') {
            return false;
        }
        boolean dig = firstIsDigit;
        for (int i = 1; i < num.length(); ++i) {
            if (!Character.isDigit(num.charAt(i))) {
                return false;
            }
            dig = true;
        }
        return dig;
    }

    public static byte[] packInt(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return new byte[]{(byte)value};
        }
        if ((value & 0xFFFF0000) == 0) {
            return new byte[]{-128, (byte)(value >>> 8), (byte)value};
        }
        return new byte[]{-127, (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int packInt(byte[] array, JBBPIntCounter position, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            array[position.getAndIncrement()] = (byte)value;
            return 1;
        }
        if ((value & 0xFFFF0000) == 0) {
            array[position.getAndIncrement()] = -128;
            array[position.getAndIncrement()] = (byte)(value >>> 8);
            array[position.getAndIncrement()] = (byte)value;
            return 3;
        }
        array[position.getAndIncrement()] = -127;
        array[position.getAndIncrement()] = (byte)(value >>> 24);
        array[position.getAndIncrement()] = (byte)(value >>> 16);
        array[position.getAndIncrement()] = (byte)(value >>> 8);
        array[position.getAndIncrement()] = (byte)value;
        return 5;
    }

    public static int unpackInt(byte[] array, JBBPIntCounter position) {
        int result;
        int code = array[position.getAndIncrement()] & 0xFF;
        if (code < 128) {
            return code;
        }
        switch (code) {
            case 128: {
                result = (array[position.getAndIncrement()] & 0xFF) << 8 | array[position.getAndIncrement()] & 0xFF;
                break;
            }
            case 129: {
                result = (array[position.getAndIncrement()] & 0xFF) << 24 | (array[position.getAndIncrement()] & 0xFF) << 16 | (array[position.getAndIncrement()] & 0xFF) << 8 | array[position.getAndIncrement()] & 0xFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported packed integer prefix [0x" + Integer.toHexString(code).toUpperCase(Locale.ENGLISH) + ']');
            }
        }
        return result;
    }

    public static String array2hex(byte[] array) {
        return JBBPUtils.byteArray2String(array, "0x", ", ", true, 16);
    }

    public static String array2bin(byte[] array) {
        return JBBPUtils.byteArray2String(array, "0b", ", ", true, 2);
    }

    public static String array2oct(byte[] array) {
        return JBBPUtils.byteArray2String(array, "0o", ", ", true, 8);
    }

    public static String byteArray2String(byte[] array, String prefix, String delimiter, boolean brackets, int radix) {
        if (array == null) {
            return null;
        }
        int maxlen = Integer.toString(255, radix).length();
        String zero = "00000000";
        String normDelim = delimiter == null ? " " : delimiter;
        String normPrefix = prefix == null ? "" : prefix;
        StringBuilder result = new StringBuilder(array.length * 4);
        if (brackets) {
            result.append('[');
        }
        boolean nofirst = false;
        for (byte b : array) {
            if (nofirst) {
                result.append(normDelim);
            } else {
                nofirst = true;
            }
            result.append(normPrefix);
            String v = Integer.toString(b & 0xFF, radix);
            if (v.length() < maxlen) {
                result.append("00000000".substring(0, maxlen - v.length()));
            }
            result.append(v.toUpperCase(Locale.ENGLISH));
        }
        if (brackets) {
            result.append(']');
        }
        return result.toString();
    }

    public static byte reverseBitsInByte(byte value) {
        int v = value & 0xFF;
        return (byte)((v * 2050 & 0x22110 | v * 32800 & 0x88440) * 65793 >> 16);
    }

    public static byte reverseBitsInByte(JBBPBitNumber bitNumber, byte value) {
        byte reversed = JBBPUtils.reverseBitsInByte(value);
        return (byte)(reversed >>> 8 - bitNumber.getBitNumber() & bitNumber.getMask());
    }

    public static String bin2str(byte[] values) {
        return JBBPUtils.bin2str(values, JBBPBitOrder.LSB0, false);
    }

    public static String bin2str(byte[] values, boolean separateBytes) {
        return JBBPUtils.bin2str(values, JBBPBitOrder.LSB0, separateBytes);
    }

    public static String bin2str(byte[] values, JBBPBitOrder bitOrder, boolean separateBytes) {
        if (values == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(values.length * (separateBytes ? 9 : 8));
        boolean nofirst = false;
        for (int n : values) {
            int i;
            if (separateBytes) {
                if (nofirst) {
                    result.append(' ');
                } else {
                    nofirst = true;
                }
            }
            int a = n;
            if (bitOrder == JBBPBitOrder.MSB0) {
                for (i = 0; i < 8; ++i) {
                    result.append((a & 1) == 0 ? (char)'0' : '1');
                    a >>= 1;
                }
                continue;
            }
            for (i = 0; i < 8; ++i) {
                result.append((a & 0x80) == 0 ? (char)'0' : '1');
                a <<= 1;
            }
        }
        return result.toString();
    }

    public static List<JBBPAbstractField> fieldsAsList(JBBPAbstractField ... fields) {
        ArrayList<JBBPAbstractField> result = new ArrayList<JBBPAbstractField>();
        for (JBBPAbstractField f : fields) {
            result.add(f);
        }
        return result;
    }

    public static byte[] str2bin(String values) {
        return JBBPUtils.str2bin(values, JBBPBitOrder.LSB0);
    }

    public static byte[] str2bin(String values, JBBPBitOrder bitOrder) {
        if (values == null) {
            return new byte[0];
        }
        int buff = 0;
        int cnt = 0;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(values.length() + 7 >> 3);
        boolean msb0 = bitOrder == JBBPBitOrder.MSB0;
        block5: for (char v : values.toCharArray()) {
            switch (v) {
                case ' ': 
                case '_': {
                    continue block5;
                }
                case '0': 
                case 'X': 
                case 'Z': 
                case 'x': 
                case 'z': {
                    if (msb0) {
                        buff >>= 1;
                        break;
                    }
                    buff <<= 1;
                    break;
                }
                case '1': {
                    if (msb0) {
                        buff = buff >> 1 | 0x80;
                        break;
                    }
                    buff = buff << 1 | 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Detected unsupported char '" + v + ']');
                }
            }
            if (++cnt != 8) continue;
            buffer.write(buff);
            cnt = 0;
            buff = 0;
        }
        if (cnt > 0) {
            buffer.write(msb0 ? buff >>> 8 - cnt : buff);
        }
        return buffer.toByteArray();
    }

    public static String[] splitString(String str, char splitChar) {
        int length = str.length();
        StringBuilder bulder = new StringBuilder(Math.max(8, length));
        int counter = 1;
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) != splitChar) continue;
            ++counter;
        }
        String[] result = new String[counter];
        int position = 0;
        for (int i = 0; i < length; ++i) {
            char chr = str.charAt(i);
            if (chr == splitChar) {
                result[position++] = bulder.toString();
                bulder.setLength(0);
                continue;
            }
            bulder.append(chr);
        }
        if (position < result.length) {
            result[position] = bulder.toString();
        }
        return result;
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message == null ? "Object is null" : message);
        }
    }

    public static String int2msg(int number) {
        return number + " (0x" + Long.toHexString((long)number & 0xFFFFFFFFL).toUpperCase(Locale.ENGLISH) + ')';
    }

    public static String normalizeFieldNameOrPath(String nameOrPath) {
        JBBPUtils.assertNotNull(nameOrPath, "Name of path must not be null");
        return nameOrPath.trim().toLowerCase(Locale.ENGLISH);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] str2UnicodeByteArray(JBBPByteOrder byteOrder, String str) {
        byte[] result = new byte[str.length() << 1];
        int index = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            char val = str.charAt(i);
            switch (byteOrder) {
                case BIG_ENDIAN: {
                    result[index++] = (byte)(val >> 8);
                    result[index++] = (byte)val;
                    continue block4;
                }
                case LITTLE_ENDIAN: {
                    result[index++] = (byte)val;
                    result[index++] = (byte)(val >> 8);
                    continue block4;
                }
                default: {
                    throw new Error("Unexpected byte order [" + (Object)((Object)byteOrder) + ']');
                }
            }
        }
        return result;
    }

    public static byte[] reverseArray(byte[] nullableArrayToBeInverted) {
        if (nullableArrayToBeInverted != null && nullableArrayToBeInverted.length > 0) {
            int indexStart = 0;
            for (int indexEnd = nullableArrayToBeInverted.length - 1; indexStart < indexEnd; ++indexStart, --indexEnd) {
                byte a = nullableArrayToBeInverted[indexStart];
                nullableArrayToBeInverted[indexStart] = nullableArrayToBeInverted[indexEnd];
                nullableArrayToBeInverted[indexEnd] = a;
            }
        }
        return nullableArrayToBeInverted;
    }

    public static byte[] splitInteger(int value, boolean valueInLittleEndian, byte[] buffer) {
        byte[] result = buffer == null || buffer.length < 4 ? new byte[4] : buffer;
        int tmpvalue = value;
        if (valueInLittleEndian) {
            for (int i = 0; i < 4; ++i) {
                result[i] = (byte)tmpvalue;
                tmpvalue >>>= 8;
            }
        } else {
            for (int i = 3; i >= 0; --i) {
                result[i] = (byte)tmpvalue;
                tmpvalue >>>= 8;
            }
        }
        return result;
    }

    public static byte[] splitLong(long value, boolean valueInLittleEndian, byte[] buffer) {
        byte[] result = buffer == null || buffer.length < 8 ? new byte[8] : buffer;
        long tmpvalue = value;
        if (valueInLittleEndian) {
            for (int i = 0; i < 8; ++i) {
                result[i] = (byte)tmpvalue;
                tmpvalue >>>= 8;
            }
        } else {
            for (int i = 7; i >= 0; --i) {
                result[i] = (byte)tmpvalue;
                tmpvalue >>>= 8;
            }
        }
        return result;
    }

    public static byte[] concat(byte[] ... arrays) {
        int len = 0;
        for (byte[] arr : arrays) {
            len += arr.length;
        }
        byte[] result = new byte[len];
        int pos = 0;
        for (byte[] arr : arrays) {
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static long reverseByteOrder(long value, int numOfLowerBytesToInvert) {
        if (numOfLowerBytesToInvert < 1 || numOfLowerBytesToInvert > 8) {
            throw new IllegalArgumentException("Wrong number of bytes [" + numOfLowerBytesToInvert + ']');
        }
        long result = 0L;
        int offsetInResult = (numOfLowerBytesToInvert - 1) * 8;
        while (numOfLowerBytesToInvert-- > 0) {
            long thebyte = value & 0xFFL;
            value >>>= 8;
            result |= thebyte << offsetInResult;
            offsetInResult -= 8;
        }
        return result;
    }

    public static String ulong2str(long ulongValue, int radix, char[] charBuffer) {
        String result;
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Illegal radix [" + radix + ']');
        }
        if (ulongValue == 0L) {
            return "0";
        }
        long cur = ulongValue;
        if (cur > 0L) {
            result = Long.toString(cur, radix).toUpperCase(Locale.ENGLISH);
        } else {
            char[] buffer = charBuffer == null || charBuffer.length < 64 ? new char[64] : charBuffer;
            int pos = buffer.length;
            long topPart = cur >>> 32;
            long bottomPart = (cur & 0xFFFFFFFFL) + (topPart % (long)radix << 32);
            topPart /= (long)radix;
            while ((bottomPart | topPart) > 0L) {
                int val = (int)(bottomPart % (long)radix);
                buffer[--pos] = (char)(val < 10 ? 48 + val : 65 + val - 10);
                bottomPart = bottomPart / (long)radix + (topPart % (long)radix << 32);
                topPart /= (long)radix;
            }
            result = new String(buffer, pos, buffer.length - pos);
        }
        return result;
    }

    public static String ensureMinTextLength(String text, int neededLen, char ch, int mode) {
        int number = neededLen - text.length();
        if (number <= 0) {
            return text;
        }
        StringBuilder result = new StringBuilder(neededLen);
        switch (mode) {
            case 0: {
                for (int i = 0; i < number; ++i) {
                    result.append(ch);
                }
                result.append(text);
                break;
            }
            case 1: {
                result.append(text);
                for (int i = 0; i < number; ++i) {
                    result.append(ch);
                }
                break;
            }
            default: {
                int leftField = number / 2;
                int rightField = number - leftField;
                while (leftField-- > 0) {
                    result.append(ch);
                }
                result.append(text);
                while (rightField-- > 0) {
                    result.append(ch);
                }
                break block0;
            }
        }
        return result.toString();
    }

    public static String removeLeadingZeros(String str) {
        String result = str;
        if (str != null && str.length() != 0) {
            char ch;
            int startIndex;
            for (startIndex = 0; startIndex < str.length() - 1 && (ch = str.charAt(startIndex)) == '0'; ++startIndex) {
            }
            if (startIndex > 0) {
                result = str.substring(startIndex);
            }
        }
        return result;
    }

    public static String removeTrailingZeros(String str) {
        String result = str;
        if (str != null && str.length() != 0) {
            char ch;
            int endIndex;
            for (endIndex = str.length(); endIndex > 1 && (ch = str.charAt(endIndex - 1)) == '0'; --endIndex) {
            }
            if (endIndex < str.length()) {
                result = str.substring(0, endIndex);
            }
        }
        return result;
    }

    public static boolean arrayStartsWith(byte[] array, byte[] str) {
        boolean result = false;
        if (array.length >= str.length) {
            result = true;
            int index = str.length;
            while (--index >= 0) {
                if (array[index] == str[index]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean arrayEndsWith(byte[] array, byte[] str) {
        boolean result = false;
        if (array.length >= str.length) {
            result = true;
            int index = str.length;
            int arrindex = array.length;
            while (--index >= 0) {
                if (array[--arrindex] == str[index]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static int makeMask(int value) {
        if (value == 0) {
            return 0;
        }
        if ((value & Integer.MIN_VALUE) != 0) {
            return -1;
        }
        int msk = 1;
        while ((msk <<= 1) <= value) {
        }
        return msk - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrivilegedProcessor
    implements PrivilegedAction<AccessibleObject> {
        private AccessibleObject theObject;

        private PrivilegedProcessor() {
        }

        public void setAccessibleObject(AccessibleObject obj) {
            this.theObject = obj;
        }

        @Override
        public AccessibleObject run() {
            AccessibleObject objectToProcess = this.theObject;
            this.theObject = null;
            if (objectToProcess != null) {
                objectToProcess.setAccessible(true);
            }
            return objectToProcess;
        }
    }
}

