/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

import com.igormaznitsa.jbbp.exceptions.JBBPIOException;
import com.igormaznitsa.jbbp.io.AbstractMappedClassFieldObserver;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPFieldBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldByte;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldUShort;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class JBBPTextWriter
extends FilterWriter {
    private MappedObjectLogger mappedClassObserver;
    private static final String DEFAULT_COMMENT_PREFIX = "; ";
    private static final String DEFAULT_VALUE_POSTFIX = "";
    private static final String DEFAULT_HR_PREFIX = ";";
    private static final String DEFAULT_FIRST_VALUE_LINE_PREFIX = "";
    private static final String DEFAULT_VALUE_PREFIX = "";
    private static final String DEFAULT_VALUE_DELIMITER = " ";
    private static final int DEFAULT_MAX_VALUES_PER_LINE = -1;
    private static final int DEFAULT_RADIX = 16;
    private static final int DEFAULT_HR_LENGTH = 80;
    private static final char DEFAUTL_HR_CHAR = '-';
    private final String lineSeparator;
    private static final int MODE_START_LINE = 0;
    private static final int MODE_VALUES = 1;
    private static final int MODE_COMMENTS = 2;
    private int prevMode = 0;
    private int mode = 0;
    private int hrLength = 80;
    private char hrChar = (char)45;
    private int radix;
    private int maxCharsRadixForByte;
    private int maxCharsRadixForShort;
    private int maxCharsRadixForInt;
    private int maxCharsRadixForLong;
    private boolean flagCommentsAllowed;
    private JBBPByteOrder byteOrder;
    private String prefixFirtValueAtLine;
    private String prefixValue;
    private String postfixValue = "";
    private String valueSeparator;
    private String prefixComment;
    private String prefixHR;
    private int linePosition = 0;
    private int lineNumber = 0;
    private int spacesInTab = 4;
    private int indent = 0;
    private int valuesLineCounter;
    private int maxValuesPerLine = -1;
    private final char[] CHAR_BUFFER = new char[64];
    private int prevLineCommentsStartPosition = 0;
    private final List<Extra> extras = new ArrayList<Extra>();

    public JBBPTextWriter() {
        this(new StringWriter(1024), JBBPByteOrder.BIG_ENDIAN, System.getProperty("line.separator"), 16, "", "", DEFAULT_COMMENT_PREFIX, DEFAULT_HR_PREFIX, DEFAULT_VALUE_DELIMITER);
    }

    public JBBPTextWriter(Writer out) {
        this(out, JBBPByteOrder.BIG_ENDIAN, System.getProperty("line.separator"), 16, "", "", DEFAULT_COMMENT_PREFIX, DEFAULT_HR_PREFIX, DEFAULT_VALUE_DELIMITER);
    }

    public JBBPTextWriter(Writer out, JBBPByteOrder byteOrder) {
        this(out, byteOrder, System.getProperty("line.separator"), 16, "", "", DEFAULT_COMMENT_PREFIX, DEFAULT_HR_PREFIX, DEFAULT_VALUE_DELIMITER);
    }

    public JBBPTextWriter(Writer out, JBBPByteOrder byteOrder, String lineSeparator, int radix, String valuePrefix, String startValueLinePrefix, String commentPrefix, String hrPrefix, String valueDelimiter) {
        super(out);
        JBBPUtils.assertNotNull(lineSeparator, "Line separator must not be null");
        this.flagCommentsAllowed = true;
        this.prefixHR = hrPrefix == null ? "" : hrPrefix;
        this.lineSeparator = lineSeparator;
        JBBPUtils.assertNotNull(out, "Writer must not be null");
        this.ByteOrder(byteOrder);
        this.SetValueSeparator(valueDelimiter);
        this.SetValueLinePrefix(startValueLinePrefix);
        this.SetCommentPrefix(commentPrefix);
        this.SetValuePrefix(valuePrefix);
        this.Radix(radix);
    }

    public Writer getWrappedWriter() {
        return this.out;
    }

    public JBBPByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getRadix() {
        return this.radix;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    private void changeMode(int mode) {
        this.prevMode = this.mode;
        this.mode = mode;
    }

    private void ensureValueMode() throws IOException {
        switch (this.mode) {
            case 0: {
                this.changeMode(1);
                for (Extra e : this.extras) {
                    e.onBeforeFirstValue(this);
                }
                this.writeIndent();
                this.write(this.prefixFirtValueAtLine);
                break;
            }
            case 2: {
                this.BR();
                this.writeIndent();
                this.changeMode(1);
                for (Extra e : this.extras) {
                    e.onBeforeFirstValue(this);
                }
                this.write(this.prefixFirtValueAtLine);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new Error("Unexpected state");
            }
        }
    }

    private void writeIndent() throws IOException {
        if (this.indent > 0) {
            for (int i = this.indent; i > 0; --i) {
                this.write(32);
            }
        }
    }

    private void ensureCommentMode() throws IOException {
        switch (this.mode) {
            case 0: {
                this.writeIndent();
                this.prevLineCommentsStartPosition = this.linePosition;
                this.write(this.prefixComment);
                this.changeMode(2);
                break;
            }
            case 1: {
                this.prevLineCommentsStartPosition = this.linePosition;
                this.write(this.prefixComment);
                this.changeMode(2);
                break;
            }
            case 2: {
                this.BR();
                this.writeIndent();
                while (this.linePosition < this.prevLineCommentsStartPosition) {
                    this.write(32);
                }
                this.write(this.prefixComment);
                break;
            }
            default: {
                throw new Error("Unexpected state");
            }
        }
    }

    private void ensureNewLineMode() throws IOException {
        if (this.mode != 0) {
            this.write(this.lineSeparator);
            this.mode = 0;
        }
        this.valuesLineCounter = 0;
    }

    private void printValueString(String value) throws IOException {
        if (this.valuesLineCounter > 0 && this.valueSeparator.length() > 0) {
            this.write(this.valueSeparator);
        }
        if (this.prefixValue.length() > 0) {
            this.write(this.prefixValue);
        }
        this.write(value);
        if (this.postfixValue.length() > 0) {
            this.write(this.postfixValue);
        }
        ++this.valuesLineCounter;
        if (this.maxValuesPerLine > 0 && this.valuesLineCounter >= this.maxValuesPerLine) {
            for (Extra e : this.extras) {
                e.onReachedMaxValueNumberForLine(this);
            }
            this.ensureNewLineMode();
        }
    }

    public JBBPTextWriter EnableComments() {
        this.flagCommentsAllowed = true;
        return this;
    }

    public JBBPTextWriter DisableComments() {
        this.flagCommentsAllowed = false;
        return this;
    }

    public JBBPTextWriter Str(String ... str) throws IOException {
        JBBPUtils.assertNotNull(str, "String must not be null");
        String oldPrefix = this.prefixValue;
        String oldPostfix = this.postfixValue;
        this.prefixValue = "";
        this.postfixValue = "";
        for (String s2 : str) {
            this.ensureValueMode();
            this.printValueString(s2 == null ? "<NULL>" : s2);
        }
        this.prefixValue = oldPrefix;
        this.postfixValue = oldPostfix;
        return this;
    }

    public JBBPTextWriter Byte(int value) throws IOException {
        Extra e;
        this.ensureValueMode();
        String convertedByExtras = null;
        Iterator<Extra> iterator = this.extras.iterator();
        while (iterator.hasNext() && (convertedByExtras = (e = iterator.next()).doConvertByteToStr(this, value & 0xFF)) == null) {
        }
        if (convertedByExtras == null) {
            this.printValueString(JBBPUtils.ensureMinTextLength(JBBPUtils.ulong2str(value & 0xFF, this.radix, this.CHAR_BUFFER), this.maxCharsRadixForByte, '0', 0));
        } else {
            this.printValueString(convertedByExtras);
        }
        return this;
    }

    public JBBPTextWriter Byte(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.Byte(value.charAt(i));
        }
        return this;
    }

    public JBBPTextWriter Byte(byte[] values) throws IOException {
        return this.Byte(values, 0, values.length);
    }

    public JBBPTextWriter Byte(byte[] array, int off, int len) throws IOException {
        this.ensureValueMode();
        while (len-- > 0) {
            this.Byte(array[off++]);
        }
        return this;
    }

    public boolean isLineStart() {
        return this.mode == 0;
    }

    public boolean isComments() {
        return this.mode == 2;
    }

    public boolean isValues() {
        return this.mode == 1;
    }

    public final JBBPTextWriter SetValueLinePrefix(String text) {
        this.prefixFirtValueAtLine = text == null ? "" : text;
        return this;
    }

    public final JBBPTextWriter SetValuePrefix(String text) {
        this.prefixValue = text == null ? "" : text;
        return this;
    }

    public final JBBPTextWriter SetValuePostfix(String text) {
        this.postfixValue = text == null ? "" : text;
        return this;
    }

    public final JBBPTextWriter SetCommentPrefix(String text) {
        this.prefixComment = text == null ? "" : text;
        return this;
    }

    public final JBBPTextWriter SetValueSeparator(String text) {
        this.valueSeparator = text == null ? "" : text;
        return this;
    }

    public JBBPTextWriter AddExtras(Extra ... extras) {
        JBBPUtils.assertNotNull(extras, "Extras must not be null");
        for (Extra e : extras) {
            JBBPUtils.assertNotNull(e, "Extras must not be null");
            this.extras.add(0, e);
        }
        return this;
    }

    public JBBPTextWriter DelExtras(Extra ... extras) {
        JBBPUtils.assertNotNull(extras, "Extras must not be null");
        for (Extra e : extras) {
            JBBPUtils.assertNotNull(e, "Extras must not be null");
            this.extras.remove(e);
        }
        return this;
    }

    public JBBPTextWriter SetMaxValuesPerLine(int value) {
        this.maxValuesPerLine = value;
        return this;
    }

    public JBBPTextWriter SetTabSpaces(int numberOfSpacesPerTab) {
        if (numberOfSpacesPerTab <= 0) {
            throw new IllegalArgumentException("Tab must contains positive number of space chars [" + numberOfSpacesPerTab + ']');
        }
        int currentIdentSteps = this.indent / this.spacesInTab;
        this.spacesInTab = numberOfSpacesPerTab;
        this.indent = currentIdentSteps * this.spacesInTab;
        return this;
    }

    public final JBBPTextWriter ByteOrder(JBBPByteOrder order) {
        JBBPUtils.assertNotNull((Object)order, "Byte order must not be null");
        this.byteOrder = order;
        return this;
    }

    public final JBBPTextWriter Radix(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Unsupported radix value [" + radix + ']');
        }
        this.radix = radix;
        this.maxCharsRadixForByte = JBBPUtils.ulong2str(255L, this.radix, this.CHAR_BUFFER).length();
        this.maxCharsRadixForShort = JBBPUtils.ulong2str(65535L, this.radix, this.CHAR_BUFFER).length();
        this.maxCharsRadixForInt = JBBPUtils.ulong2str(0xFFFFFFFFL, this.radix, this.CHAR_BUFFER).length();
        this.maxCharsRadixForLong = JBBPUtils.ulong2str(-1L, this.radix, this.CHAR_BUFFER).length();
        return this;
    }

    public JBBPTextWriter Short(int value) throws IOException {
        Extra e;
        this.ensureValueMode();
        String convertedByExtras = null;
        Iterator<Extra> iterator = this.extras.iterator();
        while (iterator.hasNext() && (convertedByExtras = (e = iterator.next()).doConvertShortToStr(this, value & 0xFFFF)) == null) {
        }
        if (convertedByExtras == null) {
            long valueToWrite = this.byteOrder == JBBPByteOrder.LITTLE_ENDIAN ? JBBPUtils.reverseByteOrder(value, 2) : (long)value;
            this.printValueString(JBBPUtils.ensureMinTextLength(JBBPUtils.ulong2str(valueToWrite & 0xFFFFL, this.radix, this.CHAR_BUFFER), this.maxCharsRadixForShort, '0', 0));
        } else {
            this.printValueString(convertedByExtras);
        }
        return this;
    }

    public JBBPTextWriter Short(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.Short(value.charAt(i));
        }
        return this;
    }

    public JBBPTextWriter Short(short[] values) throws IOException {
        return this.Short(values, 0, values.length);
    }

    public JBBPTextWriter Short(short[] values, int off, int len) throws IOException {
        while (len-- > 0) {
            this.Short(values[off++]);
        }
        return this;
    }

    public JBBPTextWriter Int(int value) throws IOException {
        Extra e;
        this.ensureValueMode();
        String convertedByExtras = null;
        Iterator<Extra> iterator = this.extras.iterator();
        while (iterator.hasNext() && (convertedByExtras = (e = iterator.next()).doConvertIntToStr(this, value)) == null) {
        }
        if (convertedByExtras == null) {
            long valueToWrite = this.byteOrder == JBBPByteOrder.LITTLE_ENDIAN ? JBBPUtils.reverseByteOrder(value, 4) : (long)value;
            this.printValueString(JBBPUtils.ensureMinTextLength(JBBPUtils.ulong2str(valueToWrite & 0xFFFFFFFFL, this.radix, this.CHAR_BUFFER), this.maxCharsRadixForInt, '0', 0));
        } else {
            this.printValueString(convertedByExtras);
        }
        return this;
    }

    public JBBPTextWriter Int(int[] values) throws IOException {
        return this.Int(values, 0, values.length);
    }

    public JBBPTextWriter Int(int[] values, int off, int len) throws IOException {
        while (len-- > 0) {
            this.Int(values[off++]);
        }
        return this;
    }

    public JBBPTextWriter IndentInc() throws IOException {
        this.indent += this.spacesInTab;
        return this;
    }

    public JBBPTextWriter IndentInc(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.IndentInc();
        }
        return this;
    }

    public JBBPTextWriter IndentDec() throws IOException {
        if (this.indent > 0) {
            this.indent = Math.max(0, this.indent - this.spacesInTab);
        }
        return this;
    }

    public JBBPTextWriter IndentDec(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.IndentDec();
        }
        return this;
    }

    public JBBPTextWriter Long(long value) throws IOException {
        Extra e;
        this.ensureValueMode();
        String convertedByExtras = null;
        Iterator<Extra> iterator = this.extras.iterator();
        while (iterator.hasNext() && (convertedByExtras = (e = iterator.next()).doConvertLongToStr(this, value)) == null) {
        }
        if (convertedByExtras == null) {
            long valueToWrite = this.byteOrder == JBBPByteOrder.LITTLE_ENDIAN ? JBBPUtils.reverseByteOrder(value, 8) : value;
            this.printValueString(JBBPUtils.ensureMinTextLength(JBBPUtils.ulong2str(valueToWrite, this.radix, this.CHAR_BUFFER), this.maxCharsRadixForLong, '0', 0));
        } else {
            this.printValueString(convertedByExtras);
        }
        return this;
    }

    public JBBPTextWriter Long(long[] values) throws IOException {
        return this.Long(values, 0, values.length);
    }

    public JBBPTextWriter Long(long[] values, int off, int len) throws IOException {
        while (len-- > 0) {
            this.Long(values[off++]);
        }
        return this;
    }

    public JBBPTextWriter BR() throws IOException {
        this.write(this.lineSeparator);
        this.ensureNewLineMode();
        return this;
    }

    public JBBPTextWriter SetHR(String prefix, int length, char ch) {
        this.prefixHR = prefix == null ? "" : prefix;
        this.hrChar = ch;
        this.hrLength = length;
        return this;
    }

    public JBBPTextWriter HR() throws IOException {
        if (this.flagCommentsAllowed) {
            this.ensureNewLineMode();
            this.writeIndent();
            this.write(this.prefixHR);
            for (int i = 0; i < this.hrLength; ++i) {
                this.write(this.hrChar);
            }
        }
        this.BR();
        return this;
    }

    public JBBPTextWriter Comment(String ... comment) throws IOException {
        if (this.flagCommentsAllowed) {
            if (comment != null) {
                for (String c : comment) {
                    if (c == null) continue;
                    if (c.indexOf(10) >= 0) {
                        String[] splitted;
                        for (String s2 : splitted = c.split("\\n")) {
                            this.ensureCommentMode();
                            this.write(s2);
                        }
                        continue;
                    }
                    this.ensureCommentMode();
                    this.write(c);
                }
                this.prevLineCommentsStartPosition = 0;
            }
        } else {
            this.ensureNewLineMode();
        }
        return this;
    }

    public String toString() {
        String result = this.out instanceof StringWriter ? ((StringWriter)this.out).toString() : JBBPTextWriter.class.getName() + '(' + this.out.getClass().getName() + ")@" + System.identityHashCode(this);
        return result;
    }

    public JBBPTextWriter Obj(int objId, Object ... obj) throws IOException {
        if (this.extras.isEmpty()) {
            throw new IllegalStateException("There is not any registered extras");
        }
        for (Object c : obj) {
            Extra e;
            String str = null;
            Iterator<Extra> iterator = this.extras.iterator();
            while (iterator.hasNext() && (str = (e = iterator.next()).doConvertObjToStr(this, objId, c)) == null) {
            }
            if (str == null) continue;
            this.ensureValueMode();
            this.printValueString(str);
        }
        return this;
    }

    public JBBPTextWriter Obj(int objId, Object[] array, int off, int len) throws IOException {
        while (len-- > 0) {
            this.Obj(objId, array[off++]);
        }
        return this;
    }

    public JBBPTextWriter Bin(Object ... objs) throws IOException {
        if (this.mappedClassObserver == null) {
            this.mappedClassObserver = new MappedObjectLogger();
        }
        this.ensureNewLineMode();
        for (Object obj : objs) {
            if (obj == null) {
                this.write("<NULL>");
                continue;
            }
            if (obj instanceof JBBPAbstractField) {
                this.printAbstractFieldObject(null, (JBBPAbstractField)obj);
                continue;
            }
            this.mappedClassObserver.init();
            this.mappedClassObserver.processObject(obj);
        }
        return this;
    }

    protected static String makeFieldComment(JBBPAbstractField field) {
        String path = field.getFieldPath();
        StringBuilder result = new StringBuilder(128);
        result.append(field.getTypeAsString()).append(' ');
        if (path == null) {
            result.append("<anonymous>");
        } else {
            result.append(path);
        }
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void printAbstractFieldObject(String postText, JBBPAbstractField field) throws IOException {
        String postfix;
        String string = postfix = postText == null ? "" : DEFAULT_VALUE_DELIMITER + postText;
        if (field instanceof JBBPAbstractArrayField || field instanceof JBBPFieldStruct) {
            this.HR();
            this.Comment(" Start " + JBBPTextWriter.makeFieldComment(field) + postfix);
            this.HR();
            this.IndentInc();
            if (field instanceof JBBPAbstractArrayField) {
                JBBPAbstractArrayField array = (JBBPAbstractArrayField)field;
                if (array.size() > 0) {
                    if (array instanceof JBBPFieldArrayBit) {
                        this.Byte(((JBBPFieldArrayBit)array).getArray());
                    } else if (array instanceof JBBPFieldArrayBoolean) {
                        boolean[] boolArray = ((JBBPFieldArrayBoolean)array).getArray();
                        String[] arrayToPrint = new String[boolArray.length];
                        for (int i = 0; i < boolArray.length; ++i) {
                            arrayToPrint[i] = boolArray[i] ? "T" : "F";
                        }
                        this.Str(arrayToPrint);
                    } else if (array instanceof JBBPFieldArrayByte) {
                        this.Byte(((JBBPFieldArrayByte)array).getArray());
                    } else if (array instanceof JBBPFieldArrayInt) {
                        this.Int(((JBBPFieldArrayInt)array).getArray());
                    } else if (array instanceof JBBPFieldArrayLong) {
                        this.Long(((JBBPFieldArrayLong)array).getArray());
                    } else if (array instanceof JBBPFieldArrayShort) {
                        this.Short(((JBBPFieldArrayShort)array).getArray());
                    } else if (array instanceof JBBPFieldArrayStruct) {
                        JBBPFieldArrayStruct structArray = (JBBPFieldArrayStruct)array;
                        int index = 0;
                        for (JBBPFieldStruct s2 : structArray.getArray()) {
                            this.printAbstractFieldObject('[' + Integer.toString(index++) + ']', s2);
                        }
                    } else if (array instanceof JBBPFieldArrayUByte) {
                        this.Byte(((JBBPFieldArrayUByte)array).getArray());
                    } else {
                        if (!(array instanceof JBBPFieldArrayUShort)) throw new Error("Unexpected field [" + field.getClass() + ']');
                        this.Short(((JBBPFieldArrayUShort)array).getArray());
                    }
                }
            } else {
                JBBPFieldStruct struct = (JBBPFieldStruct)field;
                for (JBBPAbstractField f : struct.getArray()) {
                    this.printAbstractFieldObject(null, f);
                }
            }
            this.IndentDec();
            this.HR();
            this.Comment(" End " + JBBPTextWriter.makeFieldComment(field) + postfix);
            this.HR();
            return;
        }
        if (!(field instanceof JBBPNumericField)) return;
        JBBPNumericField numeric = (JBBPNumericField)((Object)field);
        if (numeric instanceof JBBPFieldBit) {
            this.Byte(numeric.getAsInt());
        } else if (numeric instanceof JBBPFieldBoolean) {
            this.Str(numeric.getAsBool() ? "T" : "F");
        } else if (numeric instanceof JBBPFieldByte) {
            this.Byte(numeric.getAsInt());
        } else if (numeric instanceof JBBPFieldInt) {
            this.Int(numeric.getAsInt());
        } else if (numeric instanceof JBBPFieldLong) {
            this.Long(numeric.getAsLong());
        } else if (numeric instanceof JBBPFieldShort) {
            this.Short(numeric.getAsInt());
        } else if (numeric instanceof JBBPFieldUByte) {
            this.Byte(numeric.getAsInt());
        } else {
            if (!(numeric instanceof JBBPFieldUShort)) throw new Error("Unexpected field [" + field.getClass() + ']');
            this.Short(numeric.getAsInt());
        }
        this.Comment(DEFAULT_VALUE_DELIMITER + JBBPTextWriter.makeFieldComment(field) + postfix);
    }

    public JBBPTextWriter Close() throws IOException {
        for (Extra e : this.extras) {
            e.onClose(this);
        }
        super.close();
        return this;
    }

    public void close() throws IOException {
        this.Close();
    }

    public JBBPTextWriter Flush() throws IOException {
        super.flush();
        return this;
    }

    public void flush() throws IOException {
        this.Flush();
    }

    public JBBPTextWriter Tab() throws IOException {
        this.Space(this.spacesInTab - this.linePosition % this.spacesInTab);
        return this;
    }

    public JBBPTextWriter Space(int numberOfSpaces) throws IOException {
        for (int i = 0; i < numberOfSpaces; ++i) {
            this.writeChar(' ');
        }
        return this;
    }

    private void writeChar(char chr) throws IOException {
        switch (chr) {
            case '\t': {
                this.Tab();
                break;
            }
            case '\n': {
                this.out.write(this.lineSeparator);
                ++this.lineNumber;
                this.prevMode = this.mode;
                this.mode = 0;
                this.linePosition = 0;
                for (Extra e : this.extras) {
                    e.onNewLine(this, this.lineNumber);
                }
                break;
            }
            case '\r': {
                break;
            }
            default: {
                if (Character.isISOControl(chr)) break;
                this.out.write(chr);
                ++this.linePosition;
                if (this.mode != 0) break;
                this.mode = this.prevMode;
            }
        }
    }

    public int getLine() {
        return this.lineNumber;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(String str, int off, int len) throws IOException {
        while (len-- > 0) {
            this.writeChar(str.charAt(off++));
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len-- > 0) {
            this.writeChar(cbuf[off++]);
        }
    }

    public void write(int c) throws IOException {
        this.writeChar((char)c);
    }

    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    public Writer append(CharSequence csq) throws IOException {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    public static interface Extra {
        public void onNewLine(JBBPTextWriter var1, int var2) throws IOException;

        public void onBeforeFirstValue(JBBPTextWriter var1) throws IOException;

        public void onReachedMaxValueNumberForLine(JBBPTextWriter var1) throws IOException;

        public void onClose(JBBPTextWriter var1) throws IOException;

        public String doConvertByteToStr(JBBPTextWriter var1, int var2) throws IOException;

        public String doConvertShortToStr(JBBPTextWriter var1, int var2) throws IOException;

        public String doConvertIntToStr(JBBPTextWriter var1, int var2) throws IOException;

        public String doConvertLongToStr(JBBPTextWriter var1, long var2) throws IOException;

        public String doConvertObjToStr(JBBPTextWriter var1, int var2, Object var3) throws IOException;

        public String doConvertCustomField(JBBPTextWriter var1, Object var2, Field var3, Bin var4) throws IOException;
    }

    private final class MappedObjectLogger
    extends AbstractMappedClassFieldObserver {
        private int arrayCounter;
        private final Stack<Integer> counterStack = new Stack();

        private MappedObjectLogger() {
        }

        protected void init() {
            this.arrayCounter = 0;
            this.counterStack.clear();
        }

        private String makeFieldDescription(Field field, Bin annotation) {
            StringBuilder result = new StringBuilder();
            if (annotation.name().length() == 0) {
                result.append(field.getName());
            } else {
                result.append(annotation.name());
            }
            if (annotation.comment().length() != 0) {
                result.append(", ").append(annotation.comment());
            }
            return result.toString();
        }

        private String makeStructDescription(Object obj, Field field, Bin annotation) {
            Class<?> fieldType;
            StringBuilder result = new StringBuilder();
            Class<?> objClass = obj.getClass();
            Bin classAnno = objClass.getAnnotation(Bin.class);
            if (classAnno != null && classAnno.equals(annotation)) {
                classAnno = null;
            }
            String typeName = field == null ? obj.getClass().getSimpleName() : ((fieldType = field.getType()).isArray() ? fieldType.getComponentType().getSimpleName() : fieldType.getSimpleName());
            String name = annotation == null || annotation.name().length() == 0 ? typeName : annotation.name();
            String fieldComment = annotation == null || annotation.comment().length() == 0 ? null : annotation.comment();
            String objectComment = classAnno == null || classAnno.comment().length() == 0 ? null : classAnno.comment();
            result.append(name);
            if (fieldComment != null) {
                result.append(", ").append(fieldComment);
            }
            if (objectComment != null) {
                if (fieldComment != null) {
                    result.append('\n');
                } else {
                    result.append(", ");
                }
                result.append(objectComment);
            }
            return result.toString();
        }

        private String makeArrayDescription(Field field, Bin annotation) {
            return this.makeFieldDescription(field, annotation);
        }

        protected void onArrayEnd(Object obj, Field field, Bin annotation) {
            try {
                JBBPTextWriter.this.IndentDec();
                JBBPTextWriter.this.HR();
                if (field.getType() == String.class) {
                    JBBPTextWriter.this.Comment("END STRING : " + this.makeArrayDescription(field, annotation));
                } else {
                    JBBPTextWriter.this.Comment("END ARRAY : " + this.makeArrayDescription(field, annotation));
                }
                JBBPTextWriter.this.HR();
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log array field", ex);
            }
            finally {
                --this.arrayCounter;
            }
        }

        protected void onArrayStart(Object obj, Field field, Bin annotation, int length) {
            try {
                JBBPTextWriter.this.HR();
                if (field.getType() == String.class) {
                    JBBPTextWriter.this.Comment("STRING: " + this.makeFieldDescription(field, annotation));
                } else {
                    JBBPTextWriter.this.Comment("START ARRAY : " + this.makeArrayDescription(field, annotation) + " OF " + field.getType().getComponentType().getSimpleName() + " [" + length + ']');
                }
                JBBPTextWriter.this.HR();
                JBBPTextWriter.this.IndentInc();
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log array field", ex);
            }
            finally {
                ++this.arrayCounter;
            }
        }

        protected void onStructEnd(Object obj, Field field, Bin annotation) {
            try {
                JBBPTextWriter.this.IndentDec();
                JBBPTextWriter.this.HR();
                JBBPTextWriter.this.Comment("END : " + this.makeStructDescription(obj, field, annotation));
                JBBPTextWriter.this.HR();
                this.arrayCounter = this.counterStack.pop();
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log struct field", ex);
            }
        }

        protected void onStructStart(Object obj, Field field, Bin annotation) {
            try {
                this.counterStack.add(this.arrayCounter);
                this.arrayCounter = 0;
                JBBPTextWriter.this.HR();
                JBBPTextWriter.this.Comment("START : " + this.makeStructDescription(obj, field, annotation));
                JBBPTextWriter.this.HR();
                JBBPTextWriter.this.IndentInc();
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log short field", ex);
            }
        }

        protected void onFieldLong(Object obj, Field field, Bin annotation, long value) {
            try {
                JBBPTextWriter.this.Long(value);
                if (this.arrayCounter == 0) {
                    JBBPTextWriter.this.Comment(this.makeFieldDescription(field, annotation));
                }
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log short field", ex);
            }
        }

        protected void onFieldInt(Object obj, Field field, Bin annotation, int value) {
            try {
                JBBPTextWriter.this.Int(value);
                if (this.arrayCounter == 0) {
                    JBBPTextWriter.this.Comment(this.makeFieldDescription(field, annotation));
                }
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log int field", ex);
            }
        }

        protected void onFieldShort(Object obj, Field field, Bin annotation, boolean signed, int value) {
            try {
                JBBPTextWriter.this.Short(value);
                if (this.arrayCounter == 0) {
                    JBBPTextWriter.this.Comment(this.makeFieldDescription(field, annotation));
                }
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log short field", ex);
            }
        }

        protected void onFieldByte(Object obj, Field field, Bin annotation, boolean signed, int value) {
            try {
                JBBPTextWriter.this.Byte(value);
                if (this.arrayCounter == 0) {
                    JBBPTextWriter.this.Comment(this.makeFieldDescription(field, annotation));
                }
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log byte field", ex);
            }
        }

        protected void onFieldBool(Object obj, Field field, Bin annotation, boolean value) {
            try {
                JBBPTextWriter.this.Byte(value ? 1 : 0);
                if (this.arrayCounter == 0) {
                    JBBPTextWriter.this.Comment(this.makeFieldDescription(field, annotation));
                }
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log boolean field", ex);
            }
        }

        protected void onFieldBits(Object obj, Field field, Bin annotation, JBBPBitNumber bitNumber, int value) {
            try {
                JBBPTextWriter.this.Byte(value & bitNumber.getMask());
                if (this.arrayCounter == 0) {
                    JBBPTextWriter.this.Comment(this.makeFieldDescription(field, annotation));
                }
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log bit field", ex);
            }
        }

        protected void onFieldCustom(Object obj, Field field, Bin annotation, Object customFieldProcessor, Object value) {
            try {
                Extra e;
                if (JBBPTextWriter.this.extras.isEmpty()) {
                    throw new IllegalStateException("There is not any registered extras");
                }
                String str = null;
                Iterator iterator = JBBPTextWriter.this.extras.iterator();
                while (iterator.hasNext() && (str = (e = (Extra)iterator.next()).doConvertCustomField(JBBPTextWriter.this, obj, field, annotation)) == null) {
                }
                if (str != null) {
                    JBBPTextWriter.this.ensureValueMode();
                    JBBPTextWriter.this.printValueString(str);
                    JBBPTextWriter.this.Comment(this.makeFieldDescription(field, annotation));
                }
            }
            catch (IOException ex) {
                throw new JBBPIOException("Can't log custom field", ex);
            }
        }

        public void processObject(Object obj) {
            super.processObject(obj, null, this);
        }
    }
}

