/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JBBPSystemProperty {
    PROPERTY_INSTANTIATOR_CLASS("jbbp.mapper.instantiator"),
    PROPERTY_INPUT_INITIAL_ARRAY_BUFFER_SIZE("jbbp.input.initial.array.buffer");

    private final String propertyName;

    private JBBPSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public void set(String value) {
        System.setProperty(this.propertyName, value);
    }

    public void remove() {
        System.clearProperty(this.propertyName);
    }

    public String getAsString(String defaultValue) {
        String value = System.getProperty(this.propertyName);
        return value == null ? defaultValue : value;
    }

    public int getAsInteger(int defaultValue) {
        String value = System.getProperty(this.propertyName);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new Error("Can't get the system property '" + this.propertyName + "' as integer value, may be wrong format [" + value + ']', ex);
            }
        }
        return result;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

