/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.exceptions.JBBPFinderException;
import com.igormaznitsa.jbbp.exceptions.JBBPTooManyFieldsFoundException;
import com.igormaznitsa.jbbp.mapper.JBBPMapper;
import com.igormaznitsa.jbbp.mapper.JBBPMapperCustomFieldProcessor;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.finder.JBBPFieldFinder;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPFieldStruct
extends JBBPAbstractField
implements JBBPFieldFinder {
    private static final long serialVersionUID = -5862961302858335702L;
    private final JBBPAbstractField[] fields;

    public JBBPFieldStruct(JBBPNamedFieldInfo name, JBBPAbstractField[] fields) {
        super(name);
        JBBPUtils.assertNotNull(fields, "Array of fields must not be null");
        this.fields = fields;
    }

    public JBBPFieldStruct(JBBPNamedFieldInfo name, List<JBBPAbstractField> fields) {
        this(name, fields.toArray(new JBBPAbstractField[fields.size()]));
    }

    public JBBPAbstractField[] getArray() {
        return (JBBPAbstractField[])this.fields.clone();
    }

    @Override
    public JBBPAbstractField findFieldForPath(String fieldPath) {
        int firstIndex;
        String[] parsedName = JBBPUtils.splitString(JBBPUtils.normalizeFieldNameOrPath(fieldPath), '.');
        JBBPAbstractField found = this;
        if ("".equals(this.getFieldName())) {
            firstIndex = 0;
        } else if (parsedName[0].equals(this.getNameInfo().getFieldName())) {
            firstIndex = 1;
            found = this;
        } else {
            firstIndex = 0;
            found = null;
        }
        for (int i = firstIndex; found != null && i < parsedName.length; found = found.findFieldForName(parsedName[i]), ++i) {
            if (found instanceof JBBPFieldStruct) continue;
            throw new JBBPFinderException("Detected a field instead of a structure as one of nodes in the path '" + fieldPath + '\'', fieldPath, null);
        }
        return found;
    }

    @Override
    public JBBPAbstractField findFieldForName(String name) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(name);
        JBBPAbstractField result = null;
        for (JBBPAbstractField f : this.fields) {
            if (!normalizedName.equals(f.getFieldName())) continue;
            result = f;
            break;
        }
        return result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForType(Class<T> fieldType) {
        JBBPAbstractField result = null;
        int counter = 0;
        for (JBBPAbstractField f : this.fields) {
            if (!fieldType.isAssignableFrom(f.getClass())) continue;
            if (result == null) {
                result = (JBBPAbstractField)fieldType.cast(f);
            }
            ++counter;
        }
        if (counter > 1) {
            throw new JBBPTooManyFieldsFoundException(counter, "Detected more than one field", null, fieldType);
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFirstFieldForType(Class<T> fieldType) {
        JBBPAbstractField result = null;
        for (JBBPAbstractField f : this.fields) {
            if (!fieldType.isAssignableFrom(f.getClass())) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            break;
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findLastFieldForType(Class<T> fieldType) {
        JBBPAbstractField result = null;
        for (int i = this.fields.length - 1; i >= 0; --i) {
            JBBPAbstractField f = this.fields[i];
            if (!fieldType.isAssignableFrom(f.getClass())) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            break;
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForNameAndType(String fieldName, Class<T> fieldType) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        JBBPAbstractField result = null;
        for (JBBPAbstractField f : this.fields) {
            if (!fieldType.isAssignableFrom(f.getClass()) || !normalizedName.equals(f.getFieldName())) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            break;
        }
        return (T)result;
    }

    @Override
    public boolean nameExists(String fieldName) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        boolean result = false;
        for (JBBPAbstractField f : this.fields) {
            if (!normalizedName.equals(f.getFieldName())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean pathExists(String fieldPath) {
        String normalizedPath = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        boolean result = false;
        for (JBBPAbstractField f : this.fields) {
            if (!normalizedPath.equals(f.getFieldPath())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForPathAndType(String fieldPath, Class<T> fieldType) {
        JBBPAbstractField field = this.findFieldForPath(fieldPath);
        JBBPAbstractField result = null;
        if (field != null && fieldType.isAssignableFrom(field.getClass())) {
            result = (JBBPAbstractField)fieldType.cast(field);
        }
        return (T)result;
    }

    public <T> T mapTo(Class<T> mappingClass) {
        return this.mapTo(mappingClass, null);
    }

    public <T> T mapTo(Class<T> mappingClass, int flags) {
        return this.mapTo(mappingClass, null, flags);
    }

    public <T> T mapTo(Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor) {
        return JBBPMapper.map(this, mappingClass, customFieldProcessor);
    }

    public <T> T mapTo(Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags) {
        return JBBPMapper.map(this, mappingClass, customFieldProcessor, flags);
    }

    public <T> T mapTo(String path, Class<T> mappingClass) {
        return JBBPMapper.map(this, path, mappingClass);
    }

    public <T> T mapTo(String path, Class<T> mappingClass, int flags) {
        return JBBPMapper.map(this, path, mappingClass, flags);
    }

    public <T> T mapTo(String path, Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor) {
        return JBBPMapper.map(this, path, mappingClass, customFieldProcessor);
    }

    public <T> T mapTo(String path, Class<T> mappingClass, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags) {
        return JBBPMapper.map(this, path, mappingClass, customFieldProcessor, flags);
    }

    public Object mapTo(Object objectToMap) {
        return this.mapTo(objectToMap, null);
    }

    public Object mapTo(Object objectToMap, int flags) {
        return this.mapTo(objectToMap, null, flags);
    }

    public Object mapTo(Object objectToMap, JBBPMapperCustomFieldProcessor customFieldProcessor) {
        return JBBPMapper.map(this, objectToMap, customFieldProcessor);
    }

    public Object mapTo(Object objectToMap, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags) {
        return JBBPMapper.map(this, objectToMap, customFieldProcessor, flags);
    }

    @Override
    public String getTypeAsString() {
        return "{}";
    }
}

