/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldShort
extends JBBPAbstractField
implements JBBPNumericField {
    private static final long serialVersionUID = -6245423766682842050L;
    private final short value;

    public JBBPFieldShort(JBBPNamedFieldInfo name, short value) {
        super(name);
        this.value = value;
    }

    public int getAsInt() {
        return this.value;
    }

    public long getAsLong() {
        return this.getAsInt();
    }

    public boolean getAsBool() {
        return this.value != 0;
    }

    public static long reverseBits(short value) {
        int b0 = JBBPUtils.reverseBitsInByte((byte)value) & 0xFF;
        int b1 = JBBPUtils.reverseBitsInByte((byte)(value >> 8)) & 0xFF;
        return (short)(b0 << 8) | (short)b1;
    }

    public long getAsInvertedBitOrder() {
        return JBBPFieldShort.reverseBits(this.value);
    }

    public String getTypeAsString() {
        return "short";
    }
}

