/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.model.BitEntity;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldBit
extends JBBPAbstractField
implements JBBPNumericField,
BitEntity {
    private static final long serialVersionUID = 3113427734366331529L;
    private final int value;
    private final JBBPBitNumber bitNumber;

    public JBBPFieldBit(JBBPNamedFieldInfo name, int value, JBBPBitNumber bitNumber) {
        super(name);
        JBBPUtils.assertNotNull((Object)bitNumber, "Number of bits must not be null");
        this.bitNumber = bitNumber;
        this.value = value;
    }

    public JBBPBitNumber getBitWidth() {
        return this.bitNumber;
    }

    public int getAsInt() {
        return this.value & 0xFF;
    }

    public long getAsLong() {
        return this.getAsInt();
    }

    public boolean getAsBool() {
        return this.value != 0;
    }

    public static long reverseBits(byte value, JBBPBitNumber bits) {
        return JBBPUtils.reverseBitsInByte(value) >>> 8 - bits.getBitNumber() & bits.getMask();
    }

    public long getAsInvertedBitOrder() {
        return JBBPFieldBit.reverseBits((byte)this.value, this.bitNumber);
    }

    public String getTypeAsString() {
        return "bit:" + this.bitNumber.getBitNumber();
    }
}

