/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPFieldArrayLong
extends JBBPAbstractArrayField<JBBPFieldLong> {
    private static final long serialVersionUID = -2146959300724853264L;
    private final long[] array;

    public JBBPFieldArrayLong(JBBPNamedFieldInfo name, long[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public long[] getArray() {
        return (long[])this.array.clone();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldLong getElementAt(int index) {
        JBBPFieldLong result = new JBBPFieldLong(this.fieldNameInfo, this.array[index]);
        result.payload = this.payload;
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return (int)this.array[index];
    }

    @Override
    public long getAsLong(int index) {
        return this.array[index];
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index] != 0L;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        long[] result;
        if (reverseBits) {
            result = (long[])this.array.clone();
            for (int i = 0; i < result.length; ++i) {
                result[i] = JBBPFieldLong.reverseBits(result[i]);
            }
        } else {
            result = (long[])this.array.clone();
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "long [" + this.array.length + ']';
    }
}

