/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.mapper.instantiators;

import com.igormaznitsa.jbbp.mapper.instantiators.JBBPClassInstantiator;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPUnsafeInstantiator
implements JBBPClassInstantiator {
    private static final Object SUN_MISC_UNSAFE;
    private static final Method ALLOCATE_INSTANCE_METHOD;

    @Override
    public <T> T makeClassInstance(Class<T> klazz) throws InstantiationException {
        JBBPUtils.assertNotNull(klazz, "Class must not be null");
        try {
            return klazz.cast(ALLOCATE_INSTANCE_METHOD.invoke(SUN_MISC_UNSAFE, klazz));
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getTargetException();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            throw new InstantiationException("Can't instantiate class for exception [" + ex + ']');
        }
        catch (IllegalAccessException ex) {
            throw new InstantiationException("Can't instantiate class for exception [" + ex + ']');
        }
        catch (IllegalArgumentException ex) {
            throw new InstantiationException("Can't instantiate class for exception [" + ex + ']');
        }
    }

    static {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field singleoneInstanceField = unsafeClass.getDeclaredField("theUnsafe");
            JBBPUtils.makeAccessible(singleoneInstanceField);
            SUN_MISC_UNSAFE = (Unsafe)singleoneInstanceField.get(null);
            ALLOCATE_INSTANCE_METHOD = unsafeClass.getMethod("allocateInstance", Class.class);
            JBBPUtils.makeAccessible(ALLOCATE_INSTANCE_METHOD);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Can;t find 'sun.misc.Unsafe' class", e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Can't get sun.misc.Unsafe for illegal access", e);
        }
        catch (IllegalArgumentException e) {
            throw new Error("Can't get sun.misc.Unsafe for wrong argument", e);
        }
        catch (NoSuchFieldException e) {
            throw new Error("Can't get sun.misc.Unsafe because it doesn't exist", e);
        }
        catch (SecurityException e) {
            throw new Error("Can't get sun.misc.Unsafe for security exception", e);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Can't get the 'allocateInstance' method in sun.misc.Unsafe", e);
        }
    }
}

