/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.mapper.instantiators;

import com.igormaznitsa.jbbp.mapper.instantiators.JBBPClassInstantiator;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPSafeInstantiator
implements JBBPClassInstantiator {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private static boolean isInnerClass(Class<?> klazz) {
        return klazz.isMemberClass() && !Modifier.isStatic(klazz.getModifiers());
    }

    private static Object[] makeStubForConstructor(Class<?>[] constructorParamTypes) {
        if (constructorParamTypes.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[constructorParamTypes.length];
        for (int i = 0; i < constructorParamTypes.length; ++i) {
            Class<?> arg = constructorParamTypes[i];
            Serializable obj = arg.isArray() ? null : (arg == Byte.TYPE ? Byte.valueOf((byte)0) : (arg == Character.TYPE ? Character.valueOf('a') : (arg == Short.TYPE ? Short.valueOf((short)0) : (arg == Boolean.TYPE ? (Serializable)Boolean.FALSE : (Serializable)(arg == Integer.TYPE ? (Number)0 : (Number)(arg == Long.TYPE ? (Number)0L : (Number)(arg == Double.TYPE ? (Number)0.0 : (Number)(arg == Float.TYPE ? Float.valueOf(0.0f) : null))))))));
            result[i] = obj;
        }
        return result;
    }

    private static Constructor<?> findConstructorForInnerClass(Class<?> klazz, Class<?> declaringClass) {
        Constructor<?>[] constructors = klazz.getDeclaredConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        for (Constructor<?> c : constructors) {
            Class<?>[] params = c.getParameterTypes();
            if (params.length != 1 || params[0] != declaringClass) continue;
            return c;
        }
        return constructors[0];
    }

    private static Constructor<?> findConstructorForStaticClass(Class<?> klazz) {
        Constructor<?>[] constructors = klazz.getDeclaredConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        for (Constructor<?> c : constructors) {
            Class<?>[] params = c.getParameterTypes();
            if (params.length != 0) continue;
            return c;
        }
        return constructors[0];
    }

    @Override
    public <T> T makeClassInstance(Class<T> klazz) throws InstantiationException {
        try {
            if (JBBPSafeInstantiator.isInnerClass(klazz) || klazz.isLocalClass()) {
                Class<?> declaringClass = klazz.getEnclosingClass();
                Constructor<?> constructor = JBBPSafeInstantiator.findConstructorForInnerClass(klazz, declaringClass);
                constructor.setAccessible(true);
                return klazz.cast(constructor.newInstance(JBBPSafeInstantiator.makeStubForConstructor(constructor.getParameterTypes())));
            }
            Constructor<?> constructor = JBBPSafeInstantiator.findConstructorForStaticClass(klazz);
            constructor.setAccessible(true);
            return klazz.cast(constructor.newInstance(JBBPSafeInstantiator.makeStubForConstructor(constructor.getParameterTypes())));
        }
        catch (SecurityException ex) {
            throw new InstantiationException("Can't get access to the default constructor for class '" + klazz.getName() + "' [" + ex + ']');
        }
        catch (IllegalArgumentException ex) {
            throw new InstantiationException("Can't make class '" + klazz.getName() + "' [" + ex + ']');
        }
        catch (InvocationTargetException ex) {
            throw new InstantiationException("Can't make class '" + klazz.getName() + "' [" + ex + ']');
        }
        catch (IllegalAccessException ex) {
            throw new InstantiationException("Can't make instance of class '" + klazz.getName() + "' for access exception [" + ex + ']');
        }
    }
}

