/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.mapper.instantiators;

import com.igormaznitsa.jbbp.mapper.instantiators.JBBPClassInstantiator;
import com.igormaznitsa.jbbp.mapper.instantiators.JBBPClassInstantiatorType;
import com.igormaznitsa.jbbp.utils.JBBPSystemProperty;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPClassInstantiatorFactory {
    private static final JBBPClassInstantiatorFactory INSTANCE = new JBBPClassInstantiatorFactory();

    private JBBPClassInstantiatorFactory() {
    }

    public static JBBPClassInstantiatorFactory getInstance() {
        return INSTANCE;
    }

    public JBBPClassInstantiator make() {
        return this.make(JBBPClassInstantiatorType.AUTO);
    }

    public JBBPClassInstantiator make(JBBPClassInstantiatorType type) {
        JBBPUtils.assertNotNull((Object)type, "Type must not be null");
        String className = "com.igormaznitsa.jbbp.mapper.instantiators.JBBPSafeInstantiator";
        switch (type) {
            case AUTO: {
                String customClassName = JBBPSystemProperty.PROPERTY_INSTANTIATOR_CLASS.getAsString(null);
                if (customClassName == null) {
                    try {
                        Class<?> unsafeclazz = Class.forName("sun.misc.Unsafe");
                        unsafeclazz.getDeclaredField("theUnsafe");
                        className = "com.igormaznitsa.jbbp.mapper.instantiators.JBBPUnsafeInstantiator";
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (SecurityException securityException) {}
                    break;
                }
                className = customClassName;
                break;
            }
            case SAFE: {
                className = "com.igormaznitsa.jbbp.mapper.instantiators.JBBPSafeInstantiator";
                break;
            }
            case UNSAFE: {
                className = "com.igormaznitsa.jbbp.mapper.instantiators.JBBPUnsafeInstantiator";
                break;
            }
            default: {
                throw new Error("Unexpected type, contact developer! [" + (Object)((Object)type) + ']');
            }
        }
        try {
            Class<?> klazz = Class.forName(className);
            return (JBBPClassInstantiator)JBBPClassInstantiator.class.cast(klazz.newInstance());
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Can't make instantiator because can't find class '" + className + "', may be the class is obfuscated or wrong defined", ex);
        }
        catch (IllegalAccessException ex) {
            throw new Error("Can't make instantiator from '" + className + "'for access exception ", ex);
        }
        catch (InstantiationException ex) {
            throw new Error("Can't make instantiator from '" + className + "'for inside exception", ex);
        }
    }
}

