/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.io;

import com.igormaznitsa.jbbp.exceptions.JBBPIOException;
import com.igormaznitsa.jbbp.io.AbstractMappedClassFieldObserver;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPCustomFieldWriter;
import com.igormaznitsa.jbbp.io.JBBPOutVarProcessor;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;

public final class JBBPOut
extends AbstractMappedClassFieldObserver {
    private boolean processCommands = true;
    private final JBBPBitOrder bitOrder;
    private JBBPByteOrder byteOrder;
    private final JBBPBitOutputStream outStream;
    private boolean ended;
    private final ByteArrayOutputStream originalByteArrayOutStream;
    public static final JBBPByteOrder DEFAULT_BYTE_ORDER = JBBPByteOrder.BIG_ENDIAN;
    public static final JBBPBitOrder DEFAULT_BIT_ORDER = JBBPBitOrder.LSB0;

    public static JBBPOut BeginBin(JBBPByteOrder byteOrder, JBBPBitOrder bitOrder) {
        return new JBBPOut(new ByteArrayOutputStream(), byteOrder, bitOrder);
    }

    public static JBBPOut BeginBin(OutputStream out, JBBPByteOrder byteOrder, JBBPBitOrder bitOrder) {
        return new JBBPOut(out, byteOrder, bitOrder);
    }

    public static JBBPOut BeginBin() {
        return new JBBPOut(new ByteArrayOutputStream(), DEFAULT_BYTE_ORDER, DEFAULT_BIT_ORDER);
    }

    public static JBBPOut BeginBin(int initialSize) {
        return new JBBPOut(new ByteArrayOutputStream(initialSize), DEFAULT_BYTE_ORDER, DEFAULT_BIT_ORDER);
    }

    public static JBBPOut BeginBin(OutputStream out) {
        return new JBBPOut(out, DEFAULT_BYTE_ORDER, DEFAULT_BIT_ORDER);
    }

    public static JBBPOut BeginBin(JBBPByteOrder byteOrder) {
        return new JBBPOut(new ByteArrayOutputStream(), byteOrder, DEFAULT_BIT_ORDER);
    }

    public static JBBPOut BeginBin(JBBPBitOrder bitOrder) {
        return new JBBPOut(new ByteArrayOutputStream(), DEFAULT_BYTE_ORDER, bitOrder);
    }

    private JBBPOut(OutputStream outStream, JBBPByteOrder byteOrder, JBBPBitOrder bitOrder) {
        JBBPUtils.assertNotNull(outStream, "Out stream must not be null");
        JBBPUtils.assertNotNull((Object)byteOrder, "Byte order must not be null");
        JBBPUtils.assertNotNull((Object)bitOrder, "Bit order must not be null");
        this.outStream = outStream instanceof JBBPBitOutputStream ? (JBBPBitOutputStream)outStream : new JBBPBitOutputStream(outStream, bitOrder);
        this.bitOrder = this.outStream.getBitOrder();
        if (this.bitOrder != bitOrder) {
            throw new IllegalArgumentException("Detected JBBPBitOutputStream as argument with already defined different bit order [" + (Object)((Object)this.bitOrder) + ']');
        }
        this.byteOrder = byteOrder;
        this.originalByteArrayOutStream = outStream instanceof ByteArrayOutputStream ? (ByteArrayOutputStream)outStream : null;
    }

    public JBBPOut Align() throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this.outStream.align(0L);
        }
        return this;
    }

    public JBBPOut Align(int value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this.outStream.align(value);
        }
        return this;
    }

    public JBBPOut Skip(int numberOfBytes) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            if (numberOfBytes < 0) {
                throw new IllegalArgumentException("Value is negative");
            }
            this.Align();
            while (numberOfBytes > 0) {
                this.outStream.write(0);
                --numberOfBytes;
            }
        }
        return this;
    }

    public JBBPOut ByteOrder(JBBPByteOrder value) throws IOException {
        this.assertNotEnded();
        JBBPUtils.assertNotNull((Object)value, "Byte order must not be null");
        if (this.processCommands) {
            this.byteOrder = value;
        }
        return this;
    }

    public JBBPOut Bit(boolean value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this.outStream.writeBits(value ? 1 : 0, JBBPBitNumber.BITS_1);
        }
        return this;
    }

    public JBBPOut Bit(byte value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this._writeBits(JBBPBitNumber.BITS_1, value);
        }
        return this;
    }

    private static void assertArrayNotNull(Object array) {
        JBBPUtils.assertNotNull(array, "Array must not be null");
    }

    private static void assertStringNotNull(String str) {
        JBBPUtils.assertNotNull(str, "String must not be null");
    }

    public JBBPOut Bit(byte[] value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (byte b : value) {
                this._writeBits(JBBPBitNumber.BITS_1, b);
            }
        }
        return this;
    }

    public JBBPOut Bit(int ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (int b : value) {
                this._writeBits(JBBPBitNumber.BITS_1, b);
            }
        }
        return this;
    }

    public JBBPOut Bit(boolean ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (boolean b : value) {
                this._writeBits(JBBPBitNumber.BITS_1, b ? 1 : 0);
            }
        }
        return this;
    }

    private void _writeBits(JBBPBitNumber numberOfBits, int value) throws IOException {
        this.outStream.writeBits(value, numberOfBits);
    }

    public JBBPOut Bits(JBBPBitNumber numberOfBits, int value) throws IOException {
        this.assertNotEnded();
        JBBPUtils.assertNotNull((Object)numberOfBits, "Number of bits must not be null");
        if (this.processCommands) {
            this._writeBits(numberOfBits, value);
        }
        return this;
    }

    public JBBPOut Bits(JBBPBitNumber numberOfBits, int ... value) throws IOException {
        this.assertNotEnded();
        JBBPUtils.assertNotNull(value, "Array must not be null");
        if (this.processCommands) {
            for (int v : value) {
                this._writeBits(numberOfBits, v);
            }
        }
        return this;
    }

    public JBBPOut Bits(JBBPBitNumber numberOfBits, byte[] value) throws IOException {
        this.assertNotEnded();
        JBBPUtils.assertNotNull(value, "Array must not be null");
        if (this.processCommands) {
            for (byte b : value) {
                this._writeBits(numberOfBits, b);
            }
        }
        return this;
    }

    private void _writeByte(int value) throws IOException {
        this.outStream.write(value);
    }

    public JBBPOut Byte(int value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this._writeByte(value);
        }
        return this;
    }

    public JBBPOut Byte(int ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (int v : value) {
                this._writeByte(v);
            }
        }
        return this;
    }

    public JBBPOut Byte(byte[] value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            this.outStream.write(value);
        }
        return this;
    }

    public JBBPOut Byte(String str) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertStringNotNull(str);
        if (this.processCommands) {
            for (int i = 0; i < str.length(); ++i) {
                this.outStream.write(str.charAt(i));
            }
        }
        return this;
    }

    public JBBPOut Byte(String str, JBBPBitOrder bitOrder) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertStringNotNull(str);
        if (this.processCommands) {
            for (int i = 0; i < str.length(); ++i) {
                byte value = (byte)str.charAt(i);
                if (bitOrder == JBBPBitOrder.MSB0) {
                    value = JBBPUtils.reverseBitsInByte(value);
                }
                this.outStream.write(value);
            }
        }
        return this;
    }

    public JBBPOut Utf8(String str) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertStringNotNull(str);
        if (this.processCommands) {
            this.outStream.write(str.getBytes("UTF-8"));
        }
        return this;
    }

    public JBBPOut Bool(boolean value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this.outStream.write(value ? 1 : 0);
        }
        return this;
    }

    public JBBPOut Bool(boolean value, JBBPBitOrder bitOrder) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this.outStream.write(value ? (bitOrder == JBBPBitOrder.MSB0 ? 128 : 1) : 0);
        }
        return this;
    }

    public JBBPOut Bool(boolean ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (boolean b : value) {
                this.outStream.write(b ? 1 : 0);
            }
        }
        return this;
    }

    private void _writeShort(int value) throws IOException {
        this.outStream.writeShort(value, this.byteOrder);
    }

    public JBBPOut Short(int value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this._writeShort(value);
        }
        return this;
    }

    public JBBPOut Short(String str) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            for (int i = 0; i < str.length(); ++i) {
                this._writeShort(str.charAt(i));
            }
        }
        return this;
    }

    public JBBPOut Short(String str, JBBPBitOrder bitOrder) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            boolean msb0 = bitOrder == JBBPBitOrder.MSB0;
            for (int i = 0; i < str.length(); ++i) {
                short value = (short)str.charAt(i);
                if (msb0) {
                    value = (short)JBBPFieldShort.reverseBits(value);
                }
                this._writeShort(value);
            }
        }
        return this;
    }

    public JBBPOut Short(short[] value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (short v : value) {
                this._writeShort(v);
            }
        }
        return this;
    }

    public JBBPOut Short(int ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (int v : value) {
                this._writeShort(v);
            }
        }
        return this;
    }

    private void _writeInt(int value) throws IOException {
        this.outStream.writeInt(value, this.byteOrder);
    }

    public JBBPOut Int(int value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this._writeInt(value);
        }
        return this;
    }

    public JBBPOut Int(int ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (int v : value) {
                this._writeInt(v);
            }
        }
        return this;
    }

    public JBBPOut Float(float ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (float f : value) {
                this._writeInt(Float.floatToIntBits(f));
            }
        }
        return this;
    }

    private void _writeLong(long value) throws IOException {
        this.outStream.writeLong(value, this.byteOrder);
    }

    public JBBPOut Long(long value) throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this._writeLong(value);
        }
        return this;
    }

    public JBBPOut Double(double ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (double d : value) {
                this._writeLong(Double.doubleToLongBits(d));
            }
        }
        return this;
    }

    public JBBPOut ResetCounter() {
        this.assertNotEnded();
        if (this.processCommands) {
            this.outStream.resetCounter();
        }
        return this;
    }

    public JBBPOut Long(long ... value) throws IOException {
        this.assertNotEnded();
        JBBPOut.assertArrayNotNull(value);
        if (this.processCommands) {
            for (long l : value) {
                this._writeLong(l);
            }
        }
        return this;
    }

    public JBBPOut Var(JBBPOutVarProcessor processor, Object ... args) throws IOException {
        this.assertNotEnded();
        JBBPUtils.assertNotNull(processor, "Var processor must not be null");
        if (this.processCommands) {
            this.processCommands = processor.processVarOut(this, this.outStream, args);
        }
        return this;
    }

    public JBBPOut Flush() throws IOException {
        this.assertNotEnded();
        if (this.processCommands) {
            this.outStream.flush();
        }
        return this;
    }

    public ByteArrayOutputStream End() throws IOException {
        this.assertNotEnded();
        this.ended = true;
        this.outStream.flush();
        return this.originalByteArrayOutStream;
    }

    public long getByteCounter() {
        return this.outStream.getCounter();
    }

    protected void assertNotEnded() {
        if (this.ended) {
            throw new IllegalStateException(JBBPOut.class.getSimpleName() + " has been ended");
        }
    }

    public JBBPOut Bin(Object object) throws IOException {
        return this.Bin(object, null);
    }

    public JBBPOut Bin(Object object, JBBPCustomFieldWriter customFieldWriter) throws IOException {
        if (this.processCommands) {
            this.processObject(object, null, customFieldWriter);
        }
        return this;
    }

    protected void onFieldLong(Object obj, Field field, Bin annotation, long value) {
        try {
            this.Long(value);
        }
        catch (IOException ex) {
            throw new JBBPIOException("Can't write long value", ex);
        }
    }

    protected void onFieldInt(Object obj, Field field, Bin annotation, int value) {
        try {
            this.Int(value);
        }
        catch (IOException ex) {
            throw new JBBPIOException("Can't write int value", ex);
        }
    }

    protected void onFieldShort(Object obj, Field field, Bin annotation, boolean signed, int value) {
        try {
            this.Short(value);
        }
        catch (IOException ex) {
            throw new JBBPIOException("Can't write short value", ex);
        }
    }

    protected void onFieldByte(Object obj, Field field, Bin annotation, boolean signed, int value) {
        try {
            this.Byte(value);
        }
        catch (IOException ex) {
            throw new JBBPIOException("Can't write byte value", ex);
        }
    }

    protected void onFieldBool(Object obj, Field field, Bin annotation, boolean value) {
        try {
            this.Bool(value, annotation.bitOrder());
        }
        catch (IOException ex) {
            throw new JBBPIOException("Can't write bool value", ex);
        }
    }

    protected void onFieldBits(Object obj, Field field, Bin annotation, JBBPBitNumber bitNumber, int value) {
        try {
            this.Bits(bitNumber, value);
        }
        catch (IOException ex) {
            throw new JBBPIOException("Can't write bit value", ex);
        }
    }

    protected void onFieldCustom(Object obj, Field field, Bin annotation, Object customFieldProcessor, Object value) {
        try {
            JBBPCustomFieldWriter writer = (JBBPCustomFieldWriter)customFieldProcessor;
            writer.writeCustomField(this, this.outStream, obj, field, annotation, value);
        }
        catch (IOException ex) {
            throw new JBBPIOException("Can't write custom field", ex);
        }
    }
}

