/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.io;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JBBPBitNumber {
    BITS_1(1, 1),
    BITS_2(2, 3),
    BITS_3(3, 7),
    BITS_4(4, 15),
    BITS_5(5, 31),
    BITS_6(6, 63),
    BITS_7(7, 127),
    BITS_8(8, 255);

    private final int numberOfBits;
    private final int mask;

    private JBBPBitNumber(int numberOfBits, int mask) {
        this.numberOfBits = numberOfBits;
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    public int getBitNumber() {
        return this.numberOfBits;
    }

    public static JBBPBitNumber decode(int numberOfBits) {
        if (numberOfBits <= 0 || numberOfBits > 8) {
            throw new IllegalArgumentException("Unsupported bit number, allowed 1..8");
        }
        return JBBPBitNumber.values()[numberOfBits - 1];
    }
}

