/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.io;

import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPCountableBitStream;
import com.igormaznitsa.jbbp.utils.JBBPSystemProperty;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JBBPBitInputStream
extends FilterInputStream
implements JBBPCountableBitStream {
    protected static final int INITIAL_ARRAY_BUFFER_SIZE = JBBPSystemProperty.PROPERTY_INPUT_INITIAL_ARRAY_BUFFER_SIZE.getAsInteger(32);
    private int bitBuffer;
    private int bitsInBuffer = 0;
    private long byteCounter;
    private int markedBitBuffer;
    private int markedBitsInBuffer;
    private long markedByteCounter;
    private final boolean msb0;

    public JBBPBitInputStream(InputStream in) {
        this(in, JBBPBitOrder.LSB0);
    }

    public JBBPBitInputStream(InputStream in, JBBPBitOrder order) {
        super(in);
        this.msb0 = order == JBBPBitOrder.MSB0;
    }

    public boolean[] readBoolArray(int items) throws IOException {
        byte[] buffer;
        int pos = 0;
        if (items < 0) {
            int read;
            buffer = new byte[INITIAL_ARRAY_BUFFER_SIZE];
            while ((read = this.read(buffer, pos, buffer.length - pos)) >= 0) {
                if (buffer.length != (pos += read)) continue;
                byte[] newbuffer = new byte[buffer.length << 1];
                System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                buffer = newbuffer;
            }
        } else {
            int read;
            buffer = new byte[items];
            for (int len = items; len > 0; len -= read) {
                read = this.read(buffer, pos, len);
                if (read < 0) {
                    throw new EOFException("Have read only " + pos + " bit portions instead of " + items);
                }
                pos += read;
            }
        }
        boolean[] result = new boolean[pos];
        for (int i = 0; i < pos; ++i) {
            result[i] = buffer[i] != 0;
        }
        return result;
    }

    private byte[] _readArray(int items, JBBPBitNumber bitNumber) throws IOException {
        boolean readByteArray = bitNumber == null;
        int pos = 0;
        if (items < 0) {
            byte[] buffer = new byte[INITIAL_ARRAY_BUFFER_SIZE];
            while (true) {
                int next;
                int n = next = readByteArray ? this.read() : this.readBits(bitNumber);
                if (next < 0) break;
                if (buffer.length == pos) {
                    byte[] newbuffer = new byte[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = (byte)next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            byte[] result = new byte[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        byte[] buffer = new byte[items];
        if (readByteArray) {
            int read = this.read(buffer, 0, items);
            if (read != items) {
                throw new EOFException("Have read only " + read + " byte(s) instead of " + items + " byte(s)");
            }
        } else {
            for (int i = 0; i < items; ++i) {
                int next = this.readBits(bitNumber);
                if (next < 0) {
                    throw new EOFException("Have read only " + i + " bit portions instead of " + items);
                }
                buffer[i] = (byte)next;
            }
        }
        return buffer;
    }

    public byte[] readBitsArray(int items, JBBPBitNumber bitNumber) throws IOException {
        return this._readArray(items, bitNumber);
    }

    public byte[] readByteArray(int items) throws IOException {
        return this._readArray(items, null);
    }

    public short[] readShortArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            short[] buffer = new short[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                int next = this.readUnsignedShort(byteOrder);
                if (buffer.length == pos) {
                    short[] newbuffer = new short[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = (short)next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            short[] result = new short[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        short[] buffer = new short[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = (short)this.readUnsignedShort(byteOrder);
        }
        return buffer;
    }

    public int[] readIntArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            int[] buffer = new int[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                long next = this.readInt(byteOrder);
                if (buffer.length == pos) {
                    int[] newbuffer = new int[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = (int)next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            int[] result = new int[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        int[] buffer = new int[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = this.readInt(byteOrder);
        }
        return buffer;
    }

    public long[] readLongArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            long[] buffer = new long[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                long next = this.readLong(byteOrder);
                if (buffer.length == pos) {
                    long[] newbuffer = new long[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            long[] result = new long[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        long[] buffer = new long[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = this.readLong(byteOrder);
        }
        return buffer;
    }

    public int readUnsignedShort(JBBPByteOrder byteOrder) throws IOException {
        int b0 = this.read();
        if (b0 < 0) {
            throw new EOFException();
        }
        int b1 = this.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        return byteOrder == JBBPByteOrder.BIG_ENDIAN ? b0 << 8 | b1 : b1 << 8 | b0;
    }

    public int readInt(JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            return this.readUnsignedShort(byteOrder) << 16 | this.readUnsignedShort(byteOrder);
        }
        return this.readUnsignedShort(byteOrder) | this.readUnsignedShort(byteOrder) << 16;
    }

    public long readLong(JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            return ((long)this.readInt(byteOrder) & 0xFFFFFFFFL) << 32 | (long)this.readInt(byteOrder) & 0xFFFFFFFFL;
        }
        return (long)this.readInt(byteOrder) & 0xFFFFFFFFL | ((long)this.readInt(byteOrder) & 0xFFFFFFFFL) << 32;
    }

    public long getCounter() {
        return this.byteCounter;
    }

    public int getBitBuffer() {
        return this.bitBuffer;
    }

    public int getBufferedBitsNumber() {
        return this.bitsInBuffer;
    }

    public JBBPBitOrder getBitOrder() {
        return this.msb0 ? JBBPBitOrder.MSB0 : JBBPBitOrder.LSB0;
    }

    public int readBits(JBBPBitNumber numOfBitsToRead) throws IOException {
        int i;
        boolean doIncCounter;
        int numOfBitsAsNumber = numOfBitsToRead.getBitNumber();
        if (this.bitsInBuffer == 0 && numOfBitsAsNumber == 8) {
            int result = this.readByteFromStream();
            if (result >= 0) {
                ++this.byteCounter;
            }
            return result;
        }
        int result = 0;
        if (numOfBitsAsNumber == this.bitsInBuffer) {
            result = this.bitBuffer;
            this.bitBuffer = 0;
            this.bitsInBuffer = 0;
            ++this.byteCounter;
            return result;
        }
        int theBitBuffer = this.bitBuffer;
        int theBitBufferCounter = this.bitsInBuffer;
        boolean bl = doIncCounter = theBitBufferCounter != 0;
        for (i = numOfBitsAsNumber; i > 0; --i) {
            if (theBitBufferCounter == 0) {
                int nextByte;
                if (doIncCounter) {
                    ++this.byteCounter;
                }
                if ((nextByte = this.readByteFromStream()) < 0) {
                    if (i != numOfBitsAsNumber) break;
                    return nextByte;
                }
                theBitBuffer = nextByte;
                theBitBufferCounter = 8;
            }
            result = result << 1 | theBitBuffer & 1;
            theBitBuffer >>= 1;
            --theBitBufferCounter;
        }
        this.bitBuffer = theBitBuffer;
        this.bitsInBuffer = theBitBufferCounter;
        return JBBPUtils.reverseBitsInByte(JBBPBitNumber.decode(numOfBitsAsNumber - i), (byte)result) & 0xFF;
    }

    public boolean readBoolean() throws IOException {
        int read = this.read();
        if (read < 0) {
            throw new EOFException("Can't read a boolean value");
        }
        return read != 0;
    }

    public int readByte() throws IOException {
        int read = this.read();
        if (read < 0) {
            throw new EOFException("Can't read a byte value");
        }
        return read;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.bitBuffer = this.markedBitBuffer;
        this.byteCounter = this.markedByteCounter;
        this.bitsInBuffer = this.markedBitsInBuffer;
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markedBitBuffer = this.bitBuffer;
        this.markedByteCounter = this.byteCounter;
        this.markedBitsInBuffer = this.bitsInBuffer;
    }

    public void align(long alignByteNumber) throws IOException {
        this.alignByte();
        if (alignByteNumber > 0L) {
            for (long padding = (alignByteNumber - this.byteCounter % alignByteNumber) % alignByteNumber; padding > 0L; --padding) {
                int skippedByte = this.read();
                if (skippedByte >= 0) continue;
                throw new EOFException("Can't align for " + alignByteNumber + " byte(s)");
            }
        }
    }

    public long skip(long numOfBytes) throws IOException {
        int nxt;
        if (this.bitsInBuffer == 0) {
            long r = this.in.skip(numOfBytes);
            this.byteCounter += (long)((int)r);
            return r;
        }
        long count = 0L;
        for (long i = numOfBytes; i > 0L && (nxt = this.readBits(JBBPBitNumber.BITS_8)) >= 0; --i) {
            ++count;
        }
        return count;
    }

    private int readByteFromStream() throws IOException {
        int result = this.in.read();
        if (result >= 0 && this.msb0) {
            result = JBBPUtils.reverseBitsInByte((byte)result) & 0xFF;
        }
        return result;
    }

    private int loadNextByteInBuffer() throws IOException {
        int value = this.readByteFromStream();
        if (value < 0) {
            return value;
        }
        this.bitBuffer = value;
        this.bitsInBuffer = 8;
        return value;
    }

    public void alignByte() {
        if (this.bitsInBuffer > 0 && this.bitsInBuffer < 8) {
            ++this.byteCounter;
            this.bitsInBuffer = 0;
        }
    }

    public boolean hasAvailableData() throws IOException {
        if (this.bitsInBuffer > 0) {
            return true;
        }
        return this.loadNextByteInBuffer() >= 0;
    }

    public int read(byte[] array, int offset, int length) throws IOException {
        int nextByte;
        int count;
        if (this.bitsInBuffer == 0) {
            int readBytes = 0;
            int tmpoffset = offset;
            int tmplen = length;
            while (tmplen > 0) {
                int read = this.in.read(array, tmpoffset, tmplen);
                if (read < 0) {
                    readBytes = readBytes == 0 ? read : readBytes;
                    break;
                }
                tmplen -= read;
                tmpoffset += read;
                readBytes += read;
                this.byteCounter += (long)read;
            }
            if (this.msb0) {
                int index = offset;
                for (int number = readBytes; number > 0; --number) {
                    array[index] = JBBPUtils.reverseBitsInByte(array[index]);
                    ++index;
                }
            }
            return readBytes;
        }
        int i = offset;
        for (count = length; count > 0 && (nextByte = this.readBits(JBBPBitNumber.BITS_8)) >= 0; --count) {
            array[i++] = (byte)nextByte;
        }
        return length - count;
    }

    public void resetCounter() {
        if (this.bitsInBuffer < 8) {
            this.bitsInBuffer = 0;
            this.bitBuffer = 0;
        }
        this.byteCounter = 0L;
    }

    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    public int read() throws IOException {
        if (this.bitsInBuffer == 0) {
            int result = this.readByteFromStream();
            if (result >= 0) {
                ++this.byteCounter;
            }
            return result;
        }
        return this.readBits(JBBPBitNumber.BITS_8);
    }
}

