/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.varlen;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.utils.JBBPCompilerUtils;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPExpressionEvaluator;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPOnlyFieldEvaluator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPEvaluatorFactory {
    private static final JBBPEvaluatorFactory INSTANCE = new JBBPEvaluatorFactory();

    private JBBPEvaluatorFactory() {
    }

    public static JBBPEvaluatorFactory getInstance() {
        return INSTANCE;
    }

    public JBBPIntegerValueEvaluator make(String expression, List<JBBPNamedFieldInfo> namedFields, byte[] compiledScript) {
        JBBPIntegerValueEvaluator result;
        if (JBBPExpressionEvaluator.hasExpressionOperators(expression)) {
            result = new JBBPExpressionEvaluator(expression, namedFields, compiledScript);
        } else {
            int index = -1;
            if (expression.startsWith("$")) {
                result = new JBBPOnlyFieldEvaluator(expression.substring(1), index);
            } else {
                String externalFieldName = null;
                for (int i = namedFields.size() - 1; i >= 0; --i) {
                    JBBPNamedFieldInfo field = namedFields.get(i);
                    if (!expression.equals(field.getFieldPath())) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    result = new JBBPExpressionEvaluator(expression, namedFields, compiledScript);
                } else {
                    JBBPCompilerUtils.assertFieldIsNotArrayOrInArray(namedFields.get(index), namedFields, compiledScript);
                    result = new JBBPOnlyFieldEvaluator(externalFieldName, index);
                }
            }
        }
        return result;
    }
}

