/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.tokenizer;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPToken;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPTokenType;
import com.igormaznitsa.jbbp.exceptions.JBBPTokenizerException;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPTokenizer
implements Iterable<JBBPToken>,
Iterator<JBBPToken> {
    private JBBPToken nextItem;
    private JBBPTokenizerException detectedException;
    private static final Pattern PATTERN = Pattern.compile("\\s*\\/\\/.*$|\\s*(\\})|\\s*([^\\s\\;\\[\\]\\}\\{]+)?\\s*(?:\\[\\s*([^\\[\\]\\{\\}\\;]+)\\s*\\])?\\s*([^\\d\\s\\;\\[\\]\\}\\{\\/][^\\s\\;\\[\\]\\}\\{\\/]*)?\\s*([\\{\\;])", 8);
    private static final Pattern FIELD_TYPE_BREAK_PATTERN = Pattern.compile("^([<>])?([\\w][\\w\\$]*)(?::((?:[-]?\\d+)|(?:\\(.+\\))))?$");
    private static final Set<String> GLOBAL_RESERVED_TYPE_NAMES = new HashSet<String>();
    private final Matcher matcher;
    private int lastCharSubstingFound = -1;
    private final String processingString;
    private final Set<String> reservedTypeNames;

    public JBBPTokenizer(String str) {
        this(str, null);
    }

    public JBBPTokenizer(String str, JBBPCustomFieldTypeProcessor customFieldTypeProcessor) {
        JBBPUtils.assertNotNull(str, "String must not be null");
        if (customFieldTypeProcessor == null) {
            this.reservedTypeNames = GLOBAL_RESERVED_TYPE_NAMES;
        } else {
            this.reservedTypeNames = new HashSet<String>(GLOBAL_RESERVED_TYPE_NAMES);
            for (String customType : customFieldTypeProcessor.getCustomFieldTypes()) {
                JBBPUtils.assertNotNull(customType, "Type must not be null");
                this.reservedTypeNames.add(customType);
            }
        }
        this.processingString = str;
        this.matcher = PATTERN.matcher(this.processingString);
        this.readNextItem();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readNextItem() {
        if (this.matcher.find()) {
            String groupWholeFound = this.matcher.group(0);
            String groupWholeFoundTrimmed = groupWholeFound.trim();
            String groupCloseStruct = this.matcher.group(1);
            String groupTypeOrName = this.matcher.group(2);
            String groupArrayLength = this.matcher.group(3);
            String groupName = this.matcher.group(4);
            String groupEnder = this.matcher.group(5);
            String skipString = this.processingString.substring(Math.max(this.lastCharSubstingFound, 0), this.matcher.start()).trim();
            if (skipString.length() != 0 && !skipString.startsWith("//")) {
                this.detectedException = new JBBPTokenizerException(skipString, Math.max(this.lastCharSubstingFound, 0));
                return;
            } else {
                String fieldName;
                JBBPTokenType type = JBBPTokenType.ATOM;
                if (groupWholeFoundTrimmed.startsWith("//")) {
                    type = JBBPTokenType.COMMENT;
                } else if ("{".equals(groupEnder)) {
                    type = JBBPTokenType.STRUCT_START;
                    if (groupName != null) {
                        int position = this.matcher.start() + groupWholeFound.length() - groupWholeFoundTrimmed.length();
                        this.detectedException = new JBBPTokenizerException("Wrong structure format, it must have only name (and may be array definition)", position);
                        return;
                    }
                } else if (groupCloseStruct != null) {
                    type = JBBPTokenType.STRUCT_END;
                } else if (groupTypeOrName == null) {
                    int position = this.matcher.start() + groupWholeFound.length() - groupWholeFoundTrimmed.length();
                    this.detectedException = new JBBPTokenizerException("Detected atomic field definition without type", position);
                    return;
                }
                String fieldType = groupTypeOrName;
                String arrayLength = groupArrayLength;
                int position = this.matcher.start();
                if (type == JBBPTokenType.COMMENT) {
                    fieldName = this.matcher.group(0).trim().substring(2).trim();
                    position += groupWholeFound.indexOf(47);
                } else {
                    if (type == JBBPTokenType.STRUCT_START) {
                        fieldName = fieldType;
                        fieldType = null;
                    } else {
                        fieldName = groupName;
                    }
                    this.detectedException = this.checkFieldName(fieldName, position += groupWholeFound.length() - groupWholeFound.trim().length());
                    if (this.detectedException != null) {
                        return;
                    }
                }
                JBBPFieldTypeParameterContainer parsedType = null;
                if (fieldType != null) {
                    Matcher typeMatcher = FIELD_TYPE_BREAK_PATTERN.matcher(fieldType);
                    boolean wrongFormat = true;
                    if (typeMatcher.find()) {
                        String groupTypeByteOrder = typeMatcher.group(1);
                        String groupTypeName = typeMatcher.group(2);
                        String groupTypeExtraField = typeMatcher.group(3);
                        wrongFormat = false;
                        JBBPByteOrder byteOrder = null;
                        if (groupTypeByteOrder != null) {
                            if (">".equals(groupTypeByteOrder)) {
                                byteOrder = JBBPByteOrder.BIG_ENDIAN;
                            } else {
                                if (!"<".equals(groupTypeByteOrder)) throw new Error("Illegal byte order char, unexpected error, contact developer please [" + fieldType + ']');
                                byteOrder = JBBPByteOrder.LITTLE_ENDIAN;
                            }
                        } else {
                            byteOrder = JBBPByteOrder.BIG_ENDIAN;
                        }
                        if (!wrongFormat) {
                            parsedType = new JBBPFieldTypeParameterContainer(byteOrder, groupTypeName, groupTypeExtraField);
                        }
                    }
                    if (wrongFormat) {
                        this.detectedException = new JBBPTokenizerException("Wrong format of type definition [" + fieldType + ']', position);
                        return;
                    }
                } else {
                    parsedType = null;
                }
                this.nextItem = new JBBPToken(type, position, parsedType, arrayLength, fieldName);
                this.lastCharSubstingFound = this.matcher.end();
            }
            return;
        } else {
            if (this.lastCharSubstingFound < 0) {
                this.detectedException = new JBBPTokenizerException("Wrong format of whole string", 0);
            } else {
                String restOfString = this.processingString.substring(this.lastCharSubstingFound);
                if (restOfString.trim().length() != 0) {
                    throw new JBBPTokenizerException("Can't recognize a part of script [" + restOfString + ']', this.lastCharSubstingFound);
                }
            }
            this.nextItem = null;
        }
    }

    public static boolean isGlobalReservedName(String name) {
        return GLOBAL_RESERVED_TYPE_NAMES.contains(name);
    }

    private JBBPTokenizerException checkFieldName(String name, int position) {
        if (name != null) {
            String normalized = JBBPUtils.normalizeFieldNameOrPath(name);
            if (normalized.indexOf(46) >= 0) {
                return new JBBPTokenizerException("Field name must not contain '.' char", position);
            }
            if (this.reservedTypeNames.contains(normalized) || normalized.startsWith("$")) {
                return new JBBPTokenizerException("'" + name + "' can't be used as field name", position);
            }
        }
        return null;
    }

    @Override
    public Iterator<JBBPToken> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.detectedException != null || this.nextItem != null;
    }

    @Override
    public JBBPToken next() {
        if (this.detectedException != null) {
            JBBPTokenizerException ex = this.detectedException;
            this.detectedException = null;
            throw ex;
        }
        JBBPToken current = this.nextItem;
        if (current == null) {
            throw new NoSuchElementException("Parsing has been completed");
        }
        this.readNextItem();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    static {
        GLOBAL_RESERVED_TYPE_NAMES.add("bit");
        GLOBAL_RESERVED_TYPE_NAMES.add("bool");
        GLOBAL_RESERVED_TYPE_NAMES.add("byte");
        GLOBAL_RESERVED_TYPE_NAMES.add("ubyte");
        GLOBAL_RESERVED_TYPE_NAMES.add("short");
        GLOBAL_RESERVED_TYPE_NAMES.add("ushort");
        GLOBAL_RESERVED_TYPE_NAMES.add("int");
        GLOBAL_RESERVED_TYPE_NAMES.add("long");
        GLOBAL_RESERVED_TYPE_NAMES.add("align");
        GLOBAL_RESERVED_TYPE_NAMES.add("skip");
        GLOBAL_RESERVED_TYPE_NAMES.add("$");
    }
}

