/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.tokenizer;

import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import java.io.Serializable;

public final class JBBPFieldTypeParameterContainer
implements Serializable {
    private static final long serialVersionUID = 1557492283811982431L;
    private final JBBPByteOrder byteOrder;
    private final String typeName;
    private final String extraData;

    public JBBPFieldTypeParameterContainer(JBBPByteOrder byteOrder, String typeName, String extraData) {
        this.byteOrder = byteOrder;
        this.typeName = typeName;
        this.extraData = extraData;
    }

    public JBBPByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public String getExtraDataExpression() {
        String result = null;
        if (this.hasExpressionAsExtraData()) {
            result = this.extraData.substring(1, this.extraData.length() - 1);
        }
        return result;
    }

    public boolean hasExpressionAsExtraData() {
        return this.extraData != null && this.extraData.startsWith("(") && this.extraData.endsWith(")");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.byteOrder == JBBPByteOrder.LITTLE_ENDIAN) {
            result.append('<');
        }
        result.append(this.typeName);
        if (this.extraData != null) {
            int insertIndex = this.typeName.indexOf(32);
            insertIndex = insertIndex < 0 ? result.length() : ++insertIndex;
            result.insert(insertIndex, ':' + this.extraData);
        }
        return result.toString();
    }
}

