/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.JBBPCompiledBlock;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPToken;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPTokenizer;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPEvaluatorFactory;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.exceptions.JBBPCompilationException;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBBPCompiler {
    public static final int CODE_ALIGN = 1;
    public static final int CODE_BIT = 2;
    public static final int CODE_BOOL = 3;
    public static final int CODE_UBYTE = 4;
    public static final int CODE_BYTE = 5;
    public static final int CODE_USHORT = 6;
    public static final int CODE_SHORT = 7;
    public static final int CODE_INT = 8;
    public static final int CODE_LONG = 9;
    public static final int CODE_STRUCT_START = 10;
    public static final int CODE_STRUCT_END = 11;
    public static final int CODE_SKIP = 12;
    public static final int CODE_VAR = 13;
    public static final int CODE_RESET_COUNTER = 14;
    public static final int CODE_CUSTOMTYPE = 15;
    public static final int FLAG_NAMED = 16;
    public static final int FLAG_ARRAY = 32;
    public static final int FLAG_LITTLE_ENDIAN = 64;
    public static final int FLAG_WIDE = 128;
    public static final int EXT_FLAG_EXPRESSION_OR_WHOLESTREAM = 1;
    public static final int EXT_FLAG_EXTRA_AS_EXPRESSION = 2;

    public static JBBPCompiledBlock compile(String script) throws IOException {
        return JBBPCompiler.compile(script, null);
    }

    public static JBBPCompiledBlock compile(String script, JBBPCustomFieldTypeProcessor customTypeFieldProcessor) throws IOException {
        JBBPUtils.assertNotNull(script, "Script must not be null");
        JBBPCompiledBlock.Builder builder = JBBPCompiledBlock.prepare().setSource(script);
        ArrayList<JBBPNamedFieldInfo> namedFields = new ArrayList<JBBPNamedFieldInfo>();
        ArrayList<JBBPFieldTypeParameterContainer> customTypeFields = new ArrayList<JBBPFieldTypeParameterContainer>();
        ArrayList<JBBPIntegerValueEvaluator> varLengthEvaluators = new ArrayList<JBBPIntegerValueEvaluator>();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        ArrayList<StructStackItem> structureStack = new ArrayList<StructStackItem>();
        JBBPTokenizer parser = new JBBPTokenizer(script, customTypeFieldProcessor);
        int fieldUnrestrictedArrayOffset = -1;
        boolean hasVarFields = false;
        for (JBBPToken token : parser) {
            JBBPNamedFieldInfo f;
            if (token.isComment()) continue;
            int code = JBBPCompiler.prepareCodeForToken(token, customTypeFieldProcessor);
            int startFieldOffset = offset++;
            int extracode = code >>> 8;
            out.write(code);
            if ((code & 0x80) != 0) {
                out.write(extracode);
                ++offset;
            }
            StructStackItem currentClosedStructure = null;
            boolean writeExtraFieldNumberInCompiled = false;
            int extraFieldNumberAsInt = -1;
            int customTypeFieldIndex = -1;
            if ((code & 0xF) != 11 && fieldUnrestrictedArrayOffset >= 0 && (structureStack.isEmpty() || ((StructStackItem)structureStack.get(structureStack.size() - 1)).startStructureOffset != fieldUnrestrictedArrayOffset)) {
                throw new JBBPCompilationException("Attempt to read after a 'till-the-end' field", token);
            }
            boolean extraFieldNumericDataAsExpression = (code >>> 8 & 2) != 0;
            switch (code & 0xF) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 15: {
                    if ((code & 0xF) != 15) break;
                    if (extraFieldNumericDataAsExpression) {
                        varLengthEvaluators.add(JBBPEvaluatorFactory.getInstance().make(token.getFieldTypeParameters().getExtraDataExpression(), namedFields, out.toByteArray()));
                    } else {
                        String extraDataAsStr = token.getFieldTypeParameters().getExtraData();
                        if (extraDataAsStr == null) {
                            extraFieldNumberAsInt = 0;
                        } else {
                            try {
                                extraFieldNumberAsInt = Integer.parseInt(extraDataAsStr);
                            }
                            catch (NumberFormatException ex) {
                                throw new JBBPCompilationException("Can't parse extra data, must be numeric", token);
                            }
                        }
                        writeExtraFieldNumberInCompiled = true;
                    }
                    if (customTypeFieldProcessor.isAllowed(token.getFieldTypeParameters(), token.getFieldName(), extraFieldNumberAsInt, token.isArray())) {
                        customTypeFieldIndex = customTypeFields.size();
                        customTypeFields.add(token.getFieldTypeParameters());
                        break;
                    }
                    throw new JBBPCompilationException("Illegal parameters for custom type field", token);
                }
                case 12: {
                    if (token.getArraySizeAsString() != null) {
                        throw new JBBPCompilationException("'skip' can't be array", token);
                    }
                    if (token.getFieldName() != null) {
                        throw new JBBPCompilationException("'skip' must not be named", token);
                    }
                    if (extraFieldNumericDataAsExpression) {
                        varLengthEvaluators.add(JBBPEvaluatorFactory.getInstance().make(token.getFieldTypeParameters().getExtraDataExpression(), namedFields, out.toByteArray()));
                        break;
                    }
                    String extraNumberAsStr = token.getFieldTypeParameters().getExtraData();
                    writeExtraFieldNumberInCompiled = true;
                    if (extraNumberAsStr == null) {
                        extraFieldNumberAsInt = 1;
                        break;
                    }
                    try {
                        extraFieldNumberAsInt = Integer.parseInt(extraNumberAsStr);
                        JBBPCompiler.assertNonNegativeValue(extraFieldNumberAsInt, token);
                    }
                    catch (NumberFormatException ex) {
                        extraFieldNumberAsInt = -1;
                    }
                    break;
                }
                case 1: {
                    if (token.getArraySizeAsString() != null) {
                        throw new JBBPCompilationException("'align' can't be array", token);
                    }
                    if (token.getFieldName() != null) {
                        throw new JBBPCompilationException("'align' must not be named", token);
                    }
                    if (extraFieldNumericDataAsExpression) {
                        varLengthEvaluators.add(JBBPEvaluatorFactory.getInstance().make(token.getFieldTypeParameters().getExtraDataExpression(), namedFields, out.toByteArray()));
                        break;
                    }
                    String extraNumberAsStr = token.getFieldTypeParameters().getExtraData();
                    writeExtraFieldNumberInCompiled = true;
                    if (extraNumberAsStr == null) {
                        extraFieldNumberAsInt = 1;
                        break;
                    }
                    try {
                        extraFieldNumberAsInt = Integer.parseInt(extraNumberAsStr);
                        JBBPCompiler.assertNonNegativeValue(extraFieldNumberAsInt, token);
                    }
                    catch (NumberFormatException ex) {
                        extraFieldNumberAsInt = -1;
                    }
                    if (extraFieldNumberAsInt > 0) break;
                    throw new JBBPCompilationException("'align' size must be greater than zero [" + token.getFieldTypeParameters().getExtraData() + ']', token);
                }
                case 2: {
                    if (extraFieldNumericDataAsExpression) {
                        varLengthEvaluators.add(JBBPEvaluatorFactory.getInstance().make(token.getFieldTypeParameters().getExtraDataExpression(), namedFields, out.toByteArray()));
                        break;
                    }
                    String extraFieldNumAsStr = token.getFieldTypeParameters().getExtraData();
                    writeExtraFieldNumberInCompiled = true;
                    if (extraFieldNumAsStr == null) {
                        extraFieldNumberAsInt = 1;
                        break;
                    }
                    try {
                        extraFieldNumberAsInt = Integer.parseInt(extraFieldNumAsStr);
                        JBBPCompiler.assertNonNegativeValue(extraFieldNumberAsInt, token);
                    }
                    catch (NumberFormatException ex) {
                        extraFieldNumberAsInt = -1;
                    }
                    if (extraFieldNumberAsInt >= 1 && extraFieldNumberAsInt <= 8) break;
                    throw new JBBPCompilationException("Bit-width must be 1..8 [" + token.getFieldTypeParameters().getExtraData() + ']', token);
                }
                case 13: {
                    hasVarFields = true;
                    if (extraFieldNumericDataAsExpression) {
                        varLengthEvaluators.add(JBBPEvaluatorFactory.getInstance().make(token.getFieldTypeParameters().getExtraDataExpression(), namedFields, out.toByteArray()));
                        break;
                    }
                    String extraFieldNumStr = token.getFieldTypeParameters().getExtraData();
                    writeExtraFieldNumberInCompiled = true;
                    if (extraFieldNumStr == null) {
                        extraFieldNumberAsInt = 0;
                        break;
                    }
                    if (extraFieldNumericDataAsExpression) {
                        varLengthEvaluators.add(JBBPEvaluatorFactory.getInstance().make(token.getFieldTypeParameters().getExtraData(), namedFields, out.toByteArray()));
                        writeExtraFieldNumberInCompiled = false;
                        break;
                    }
                    try {
                        extraFieldNumberAsInt = Integer.parseInt(extraFieldNumStr);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new JBBPCompilationException("Can't parse the extra value of a VAR field, must be integer [" + token.getFieldTypeParameters().getExtraData() + ']', token);
                    }
                }
                case 14: {
                    if (token.getArraySizeAsString() != null) {
                        throw new JBBPCompilationException("A Reset counter field can't be array", token);
                    }
                    if (token.getFieldName() != null) {
                        throw new JBBPCompilationException("A Reset counter field can't be named [" + token.getFieldName() + ']', token);
                    }
                    if (token.getFieldTypeParameters().getExtraData() == null) break;
                    throw new JBBPCompilationException("A Reset counter field doesn't use extra value [" + token.getFieldName() + ']', token);
                }
                case 10: {
                    structureStack.add(new StructStackItem(namedFields.size() + ((code & 0x10) == 0 ? 0 : 1), startFieldOffset, code, token));
                    break;
                }
                case 11: {
                    if (structureStack.isEmpty()) {
                        throw new JBBPCompilationException("Detected structure close tag without opening one", token);
                    }
                    currentClosedStructure = (StructStackItem)structureStack.remove(structureStack.size() - 1);
                    offset += JBBPCompiler.writePackedInt(out, currentClosedStructure.startStructureOffset);
                    break;
                }
                default: {
                    throw new Error("Detected unsupported compiled code, notify the developer please [" + code + ']');
                }
            }
            if ((code & 0x20) != 0) {
                if ((extracode & 1) != 0) {
                    if ("_".equals(token.getArraySizeAsString())) {
                        if (fieldUnrestrictedArrayOffset >= 0) {
                            throw new JBBPCompilationException("Detected two or more unlimited arrays [" + script + ']', token);
                        }
                        fieldUnrestrictedArrayOffset = startFieldOffset;
                    } else {
                        varLengthEvaluators.add(JBBPEvaluatorFactory.getInstance().make(token.getArraySizeAsString(), namedFields, out.toByteArray()));
                    }
                } else {
                    int fixedArraySize = token.getArraySizeAsInt();
                    if (fixedArraySize <= 0) {
                        throw new JBBPCompilationException("Detected an array with negative or zero fixed length", token);
                    }
                    offset += JBBPCompiler.writePackedInt(out, token.getArraySizeAsInt());
                }
            }
            if (writeExtraFieldNumberInCompiled) {
                offset += JBBPCompiler.writePackedInt(out, extraFieldNumberAsInt);
            }
            if (customTypeFieldIndex >= 0) {
                offset += JBBPCompiler.writePackedInt(out, customTypeFieldIndex);
            }
            if ((code & 0x10) != 0) {
                String normalizedName = JBBPUtils.normalizeFieldNameOrPath(token.getFieldName());
                JBBPCompiler.assertName(normalizedName, token);
                JBBPCompiler.registerNamedField(normalizedName, structureStack.isEmpty() ? 0 : ((StructStackItem)structureStack.get(structureStack.size() - 1)).namedFieldCounter, startFieldOffset, namedFields, token);
                continue;
            }
            if (currentClosedStructure == null || (currentClosedStructure.code & 0x10) == 0) continue;
            String normalizedName = JBBPUtils.normalizeFieldNameOrPath(currentClosedStructure.token.getFieldName());
            for (int i = namedFields.size() - 1; i >= 0 && (f = (JBBPNamedFieldInfo)namedFields.get(i)).getFieldOffsetInCompiledBlock() > currentClosedStructure.startStructureOffset; --i) {
                String newFullName = normalizedName + '.' + f.getFieldPath();
                namedFields.set(i, new JBBPNamedFieldInfo(newFullName, f.getFieldName(), f.getFieldOffsetInCompiledBlock()));
            }
        }
        if (!structureStack.isEmpty()) {
            throw new JBBPCompilationException("Detected nonclosed " + structureStack.size() + " structure(s)");
        }
        byte[] compiledBlock = out.toByteArray();
        if (fieldUnrestrictedArrayOffset >= 0) {
            compiledBlock[fieldUnrestrictedArrayOffset] = (byte)(compiledBlock[fieldUnrestrictedArrayOffset] & 0xFFFFFFDF);
        }
        return builder.setNamedFieldData(namedFields).setArraySizeEvaluators(varLengthEvaluators).setCustomTypeFields(customTypeFields).setCompiledData(compiledBlock).setHasVarFields(hasVarFields).build();
    }

    private static void assertNonNegativeValue(int value, JBBPToken token) {
        if (value < 0) {
            throw new JBBPCompilationException("Detected unsupported negative value for a field must have only zero or a positive one", token);
        }
    }

    private static void assertName(String name, JBBPToken token) {
        if (name.indexOf(46) >= 0) {
            throw new JBBPCompilationException("Detected disallowed char '.' in name [" + name + ']', token);
        }
    }

    private static void registerNamedField(String normalizedName, int structureBorder, int offset, List<JBBPNamedFieldInfo> namedFields, JBBPToken token) {
        for (int i = namedFields.size() - 1; i >= structureBorder; --i) {
            JBBPNamedFieldInfo info = namedFields.get(i);
            if (!info.getFieldPath().equals(normalizedName)) continue;
            throw new JBBPCompilationException("Duplicated named field detected [" + normalizedName + ']', token);
        }
        namedFields.add(new JBBPNamedFieldInfo(normalizedName, normalizedName, offset));
    }

    private static int writePackedInt(OutputStream out, int value) throws IOException {
        byte[] packedInt = JBBPUtils.packInt(value);
        out.write(packedInt);
        return packedInt.length;
    }

    private static int prepareCodeForToken(JBBPToken token, JBBPCustomFieldTypeProcessor customTypeFieldProcessor) {
        int result = -1;
        switch (token.getType()) {
            case ATOM: {
                JBBPFieldTypeParameterContainer descriptor = token.getFieldTypeParameters();
                result = descriptor.getByteOrder() == JBBPByteOrder.LITTLE_ENDIAN ? 64 : 0;
                boolean hasExpressionAsExtraNumber = descriptor.hasExpressionAsExtraData();
                result |= token.getArraySizeAsString() == null ? 0 : (token.isVarArrayLength() ? 416 : 32);
                result |= hasExpressionAsExtraNumber ? 640 : 0;
                result |= token.getFieldName() == null ? 0 : 16;
                String name = descriptor.getTypeName().toLowerCase(Locale.ENGLISH);
                if ("skip".equals(name)) {
                    result |= 0xC;
                    break;
                }
                if ("align".equals(name)) {
                    result |= 1;
                    break;
                }
                if ("bit".equals(name)) {
                    result |= 2;
                    break;
                }
                if ("var".equals(name)) {
                    result |= 0xD;
                    break;
                }
                if ("bool".equals(name)) {
                    result |= 3;
                    break;
                }
                if ("ubyte".equals(name)) {
                    result |= 4;
                    break;
                }
                if ("byte".equals(name)) {
                    result |= 5;
                    break;
                }
                if ("ushort".equals(name)) {
                    result |= 6;
                    break;
                }
                if ("short".equals(name)) {
                    result |= 7;
                    break;
                }
                if ("int".equals(name)) {
                    result |= 8;
                    break;
                }
                if ("long".equals(name)) {
                    result |= 9;
                    break;
                }
                if ("reset$$".equals(name)) {
                    result |= 0xE;
                    break;
                }
                boolean unsupportedType = true;
                if (customTypeFieldProcessor != null) {
                    for (String s2 : customTypeFieldProcessor.getCustomFieldTypes()) {
                        if (!name.equals(s2)) continue;
                        result |= 0xF;
                        unsupportedType = false;
                        break;
                    }
                }
                if (!unsupportedType) break;
                throw new JBBPCompilationException("Unsupported type [" + descriptor.getTypeName() + ']', token);
            }
            case COMMENT: {
                break;
            }
            case STRUCT_START: {
                result = token.getArraySizeAsString() == null ? 0 : (token.isVarArrayLength() ? 416 : 32);
                result |= token.getFieldName() == null ? 0 : 16;
                result |= 0xA;
                break;
            }
            case STRUCT_END: {
                result = 11;
                break;
            }
            default: {
                throw new Error("Unsupported type detected, contact developer! [" + (Object)((Object)token.getType()) + ']');
            }
        }
        return result;
    }

    private static final class StructStackItem {
        private final int startStructureOffset;
        private final int code;
        private final JBBPToken token;
        private final int namedFieldCounter;

        private StructStackItem(int namedFieldCounter, int startStructureOffset, int code, JBBPToken token) {
            this.namedFieldCounter = namedFieldCounter;
            this.startStructureOffset = startStructureOffset;
            this.code = code;
            this.token = token;
        }
    }
}

