/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.exceptions.JBBPIllegalArgumentException;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.util.ArrayList;
import java.util.List;

public final class JBBPCompiledBlock {
    private final JBBPNamedFieldInfo[] namedFieldData;
    private final String source;
    private final byte[] compiledArray;
    private final JBBPIntegerValueEvaluator[] arraySizeEvaluators;
    private final JBBPFieldTypeParameterContainer[] customTypeFields;
    private final boolean hasVarFields;

    public static Builder prepare() {
        return new Builder();
    }

    private JBBPCompiledBlock(String source, JBBPNamedFieldInfo[] namedFields, JBBPIntegerValueEvaluator[] arraySizeEvaluators, byte[] compiledData, boolean hasVarFields, JBBPFieldTypeParameterContainer[] customTypeFields) {
        this.source = source;
        this.namedFieldData = namedFields;
        this.hasVarFields = hasVarFields;
        this.compiledArray = compiledData;
        this.arraySizeEvaluators = arraySizeEvaluators;
        this.customTypeFields = customTypeFields;
    }

    public String getSource() {
        return this.source;
    }

    public boolean hasVarFields() {
        return this.hasVarFields;
    }

    public boolean hasEvaluatedSizeArrays() {
        return this.arraySizeEvaluators != null;
    }

    public byte[] getCompiledData() {
        return this.compiledArray;
    }

    public JBBPNamedFieldInfo[] getNamedFields() {
        return this.namedFieldData;
    }

    public JBBPFieldTypeParameterContainer[] getCustomTypeFields() {
        return this.customTypeFields;
    }

    public JBBPIntegerValueEvaluator[] getArraySizeEvaluators() {
        return this.arraySizeEvaluators;
    }

    public JBBPNamedFieldInfo findFieldForPath(String fieldPath) {
        JBBPNamedFieldInfo result = null;
        for (JBBPNamedFieldInfo f : this.namedFieldData) {
            if (!f.getFieldPath().equals(fieldPath)) continue;
            result = f;
            break;
        }
        return result;
    }

    public int findFieldOffsetForPath(String fieldPath) {
        for (JBBPNamedFieldInfo f : this.namedFieldData) {
            if (!f.getFieldPath().equals(fieldPath)) continue;
            return f.getFieldOffsetInCompiledBlock();
        }
        throw new JBBPIllegalArgumentException("Unknown field path [" + fieldPath + ']');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private String source;
        private final List<JBBPNamedFieldInfo> namedFields = new ArrayList<JBBPNamedFieldInfo>();
        private byte[] compiledData;
        private boolean hasVarFields;
        private final List<JBBPIntegerValueEvaluator> varLenProcessors = new ArrayList<JBBPIntegerValueEvaluator>();
        private final List<JBBPFieldTypeParameterContainer> customTypeFields = new ArrayList<JBBPFieldTypeParameterContainer>();

        public JBBPCompiledBlock build() {
            JBBPUtils.assertNotNull(this.source, "Source is not defined");
            JBBPUtils.assertNotNull(this.compiledData, "Compiled data is not defined");
            return new JBBPCompiledBlock(this.source, this.namedFields.toArray(new JBBPNamedFieldInfo[this.namedFields.size()]), this.varLenProcessors.isEmpty() ? null : this.varLenProcessors.toArray(new JBBPIntegerValueEvaluator[this.varLenProcessors.size()]), this.compiledData, this.hasVarFields, this.customTypeFields.toArray(new JBBPFieldTypeParameterContainer[this.customTypeFields.size()]));
        }

        public Builder setHasVarFields(boolean flag) {
            this.hasVarFields = flag;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setCompiledData(byte[] compiledData) {
            this.compiledData = compiledData;
            return this;
        }

        public Builder setNamedFieldData(List<JBBPNamedFieldInfo> namedFields) {
            this.namedFields.clear();
            if (namedFields != null) {
                this.namedFields.addAll(namedFields);
            }
            return this;
        }

        public Builder setArraySizeEvaluators(List<JBBPIntegerValueEvaluator> evaluators) {
            this.varLenProcessors.clear();
            if (evaluators != null) {
                this.varLenProcessors.addAll(evaluators);
            }
            return this;
        }

        public Builder setCustomTypeFields(List<JBBPFieldTypeParameterContainer> list) {
            this.customTypeFields.clear();
            if (list != null) {
                this.customTypeFields.addAll(list);
            }
            return this;
        }
    }
}

