# Agents Overview

Welcome to the heart of the **AgentForge** framework—the **Agents**. These entities are the driving force behind the system. They manage data, render prompts, and ensure seamless operations. Here, you'll get a comprehensive understanding of how agents function, the methods they employ, the prompts guiding them, and how you can craft your own custom agents.

---

### **[Agent Base Class](AgentClass.md)**
- Dive into the foundational class from which all agents derive. You'll find a detailed breakdown of the `Agent` class, its attributes, initialization process, and the essential logic that underpins every agent in the framework.

### **[Agent Methods](AgentMethods.md)**
- A guide to the critical methods within the `Agent` base class. This is your go-to reference for understanding the functionalities that are indispensable for creating custom agents.

### **[Agent Prompts](AgentPrompts.md)**
- Explore the realm of prompts that dictate an agent's behavior and interactions. Grasp how these guiding instructions ensure agents understand their objectives and relay information effectively.

### **[Custom Agents](CustomAgents.md)**
- Want to build your own agent? Here, you'll learn how to craft custom agents tailored to fit your specific needs. Discover how to derive from the base `Agent` class, override methods, and create corresponding prompt files.

### **[Overriding LLM Settings](../Settings/Models.md)**
- Each agent holds the power to tailor the Large Language Model (LLM) settings it employs. This section delves into how agents can utilize default LLMs or opt for specific models fine-tuned for unique tasks, offering flexibility and precision.

---

