package sequences;
import java.util.HashMap;
import java.util.Map;

public class ValidAnagram {
    // 242 Valid Anagram
    // https://leetcode.com/problems/valid-anagram/

    // solution
    public boolean isAnagram(String s, String t) {
        if (s.length() != t.length()) {
            return false;
        }

        Map<Character, Integer> map = new HashMap<>();

        for (char c : s.toCharArray()) {
            map.put(c, map.getOrDefault(c, 0) + 1);
        }

        for (char c : t.toCharArray()) {
            if (map.containsKey(c) && map.get(c) > 0) {
                map.put(c, map.get(c) - 1);
            } else {
                return false;
            }
        }

        return true;
    }

    // LC discussion solution
    public boolean isAnagram2(String s, String t) {
        int[] alphabet = new int[26];
        // loop through s (increment)
        for (int i = 0; i < s.length(); i++) {
            alphabet[s.charAt(i) - 'a']++;
        }

        // loop through t (decrement)
        for (int i = 0; i < t.length(); i++) {
            alphabet[t.charAt(i) - 'a']--;
        }

        // check
        for (int i : alphabet) {
            if (i != 0) {
                return false;
            }
        }

        return true;
    }
}
