/**
 * \file
 * \brief Mock of SpiPeripheral class for SPIv2 in STM32
 *
 * \author Copyright (C) 2018-2019 Kamil Szczygiel https://distortec.com https://freddiechopin.info
 *
 * \par License
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. If a copy of the MPL was not
 * distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

#ifndef UNIT_TEST_INCLUDE_MOCKS_CHIP_STM32_SPIV2_SPIPERIPHERAL_HPP_DISTORTOS_CHIP_STM32_SPIV2_SPIPERIPHERAL_HPP_
#define UNIT_TEST_INCLUDE_MOCKS_CHIP_STM32_SPIV2_SPIPERIPHERAL_HPP_DISTORTOS_CHIP_STM32_SPIV2_SPIPERIPHERAL_HPP_

#include "unit-test-common.hpp"

namespace distortos
{

namespace chip
{

class SpiPeripheral
{
public:

	MAKE_CONST_MOCK0(getDrAddress, uintptr_t());
	MAKE_CONST_MOCK0(getPeripheralFrequency, uint32_t());
	MAKE_CONST_MOCK0(readCr1, uint32_t());
	MAKE_CONST_MOCK0(readCr2, uint32_t());
	MAKE_CONST_MOCK1(readDr, uint32_t(uint8_t));
	MAKE_CONST_MOCK0(readSr, uint32_t());
	MAKE_CONST_MOCK1(writeCr1, void(uint32_t));
	MAKE_CONST_MOCK1(writeCr2, void(uint32_t));
	MAKE_CONST_MOCK2(writeDr, void(uint8_t, uint32_t));
	MAKE_CONST_MOCK1(writeSr, void(uint32_t));
};

}	// namespace chip

}	// namespace distortos

// following definitions were copied from CMSIS-STM32L4/stm32l431xx.h

/*******************  Bit definition for SPI_CR1 register  ********************/
#define SPI_CR1_CPHA_Pos         (0U)
#define SPI_CR1_CPHA_Msk         (0x1U << SPI_CR1_CPHA_Pos)                    /*!< 0x00000001 */
#define SPI_CR1_CPHA             SPI_CR1_CPHA_Msk                              /*!<Clock Phase      */
#define SPI_CR1_CPOL_Pos         (1U)
#define SPI_CR1_CPOL_Msk         (0x1U << SPI_CR1_CPOL_Pos)                    /*!< 0x00000002 */
#define SPI_CR1_CPOL             SPI_CR1_CPOL_Msk                              /*!<Clock Polarity   */
#define SPI_CR1_MSTR_Pos         (2U)
#define SPI_CR1_MSTR_Msk         (0x1U << SPI_CR1_MSTR_Pos)                    /*!< 0x00000004 */
#define SPI_CR1_MSTR             SPI_CR1_MSTR_Msk                              /*!<Master Selection */

#define SPI_CR1_BR_Pos           (3U)
#define SPI_CR1_BR_Msk           (0x7U << SPI_CR1_BR_Pos)                      /*!< 0x00000038 */
#define SPI_CR1_BR               SPI_CR1_BR_Msk                                /*!<BR[2:0] bits (Baud Rate Control) */
#define SPI_CR1_BR_0             (0x1U << SPI_CR1_BR_Pos)                      /*!< 0x00000008 */
#define SPI_CR1_BR_1             (0x2U << SPI_CR1_BR_Pos)                      /*!< 0x00000010 */
#define SPI_CR1_BR_2             (0x4U << SPI_CR1_BR_Pos)                      /*!< 0x00000020 */

#define SPI_CR1_SPE_Pos          (6U)
#define SPI_CR1_SPE_Msk          (0x1U << SPI_CR1_SPE_Pos)                     /*!< 0x00000040 */
#define SPI_CR1_SPE              SPI_CR1_SPE_Msk                               /*!<SPI Enable                          */
#define SPI_CR1_LSBFIRST_Pos     (7U)
#define SPI_CR1_LSBFIRST_Msk     (0x1U << SPI_CR1_LSBFIRST_Pos)                /*!< 0x00000080 */
#define SPI_CR1_LSBFIRST         SPI_CR1_LSBFIRST_Msk                          /*!<Frame Format                        */
#define SPI_CR1_SSI_Pos          (8U)
#define SPI_CR1_SSI_Msk          (0x1U << SPI_CR1_SSI_Pos)                     /*!< 0x00000100 */
#define SPI_CR1_SSI              SPI_CR1_SSI_Msk                               /*!<Internal slave select               */
#define SPI_CR1_SSM_Pos          (9U)
#define SPI_CR1_SSM_Msk          (0x1U << SPI_CR1_SSM_Pos)                     /*!< 0x00000200 */
#define SPI_CR1_SSM              SPI_CR1_SSM_Msk                               /*!<Software slave management           */
#define SPI_CR1_RXONLY_Pos       (10U)
#define SPI_CR1_RXONLY_Msk       (0x1U << SPI_CR1_RXONLY_Pos)                  /*!< 0x00000400 */
#define SPI_CR1_RXONLY           SPI_CR1_RXONLY_Msk                            /*!<Receive only                        */
#define SPI_CR1_CRCL_Pos         (11U)
#define SPI_CR1_CRCL_Msk         (0x1U << SPI_CR1_CRCL_Pos)                    /*!< 0x00000800 */
#define SPI_CR1_CRCL             SPI_CR1_CRCL_Msk                              /*!< CRC Length */
#define SPI_CR1_CRCNEXT_Pos      (12U)
#define SPI_CR1_CRCNEXT_Msk      (0x1U << SPI_CR1_CRCNEXT_Pos)                 /*!< 0x00001000 */
#define SPI_CR1_CRCNEXT          SPI_CR1_CRCNEXT_Msk                           /*!<Transmit CRC next                   */
#define SPI_CR1_CRCEN_Pos        (13U)
#define SPI_CR1_CRCEN_Msk        (0x1U << SPI_CR1_CRCEN_Pos)                   /*!< 0x00002000 */
#define SPI_CR1_CRCEN            SPI_CR1_CRCEN_Msk                             /*!<Hardware CRC calculation enable     */
#define SPI_CR1_BIDIOE_Pos       (14U)
#define SPI_CR1_BIDIOE_Msk       (0x1U << SPI_CR1_BIDIOE_Pos)                  /*!< 0x00004000 */
#define SPI_CR1_BIDIOE           SPI_CR1_BIDIOE_Msk                            /*!<Output enable in bidirectional mode */
#define SPI_CR1_BIDIMODE_Pos     (15U)
#define SPI_CR1_BIDIMODE_Msk     (0x1U << SPI_CR1_BIDIMODE_Pos)                /*!< 0x00008000 */
#define SPI_CR1_BIDIMODE         SPI_CR1_BIDIMODE_Msk                          /*!<Bidirectional data mode enable      */

/*******************  Bit definition for SPI_CR2 register  ********************/
#define SPI_CR2_RXDMAEN_Pos      (0U)
#define SPI_CR2_RXDMAEN_Msk      (0x1U << SPI_CR2_RXDMAEN_Pos)                 /*!< 0x00000001 */
#define SPI_CR2_RXDMAEN          SPI_CR2_RXDMAEN_Msk                           /*!< Rx Buffer DMA Enable */
#define SPI_CR2_TXDMAEN_Pos      (1U)
#define SPI_CR2_TXDMAEN_Msk      (0x1U << SPI_CR2_TXDMAEN_Pos)                 /*!< 0x00000002 */
#define SPI_CR2_TXDMAEN          SPI_CR2_TXDMAEN_Msk                           /*!< Tx Buffer DMA Enable */
#define SPI_CR2_SSOE_Pos         (2U)
#define SPI_CR2_SSOE_Msk         (0x1U << SPI_CR2_SSOE_Pos)                    /*!< 0x00000004 */
#define SPI_CR2_SSOE             SPI_CR2_SSOE_Msk                              /*!< SS Output Enable */
#define SPI_CR2_NSSP_Pos         (3U)
#define SPI_CR2_NSSP_Msk         (0x1U << SPI_CR2_NSSP_Pos)                    /*!< 0x00000008 */
#define SPI_CR2_NSSP             SPI_CR2_NSSP_Msk                              /*!< NSS pulse management Enable */
#define SPI_CR2_FRF_Pos          (4U)
#define SPI_CR2_FRF_Msk          (0x1U << SPI_CR2_FRF_Pos)                     /*!< 0x00000010 */
#define SPI_CR2_FRF              SPI_CR2_FRF_Msk                               /*!< Frame Format Enable */
#define SPI_CR2_ERRIE_Pos        (5U)
#define SPI_CR2_ERRIE_Msk        (0x1U << SPI_CR2_ERRIE_Pos)                   /*!< 0x00000020 */
#define SPI_CR2_ERRIE            SPI_CR2_ERRIE_Msk                             /*!< Error Interrupt Enable */
#define SPI_CR2_RXNEIE_Pos       (6U)
#define SPI_CR2_RXNEIE_Msk       (0x1U << SPI_CR2_RXNEIE_Pos)                  /*!< 0x00000040 */
#define SPI_CR2_RXNEIE           SPI_CR2_RXNEIE_Msk                            /*!< RX buffer Not Empty Interrupt Enable */
#define SPI_CR2_TXEIE_Pos        (7U)
#define SPI_CR2_TXEIE_Msk        (0x1U << SPI_CR2_TXEIE_Pos)                   /*!< 0x00000080 */
#define SPI_CR2_TXEIE            SPI_CR2_TXEIE_Msk                             /*!< Tx buffer Empty Interrupt Enable */
#define SPI_CR2_DS_Pos           (8U)
#define SPI_CR2_DS_Msk           (0xFU << SPI_CR2_DS_Pos)                      /*!< 0x00000F00 */
#define SPI_CR2_DS               SPI_CR2_DS_Msk                                /*!< DS[3:0] Data Size */
#define SPI_CR2_DS_0             (0x1U << SPI_CR2_DS_Pos)                      /*!< 0x00000100 */
#define SPI_CR2_DS_1             (0x2U << SPI_CR2_DS_Pos)                      /*!< 0x00000200 */
#define SPI_CR2_DS_2             (0x4U << SPI_CR2_DS_Pos)                      /*!< 0x00000400 */
#define SPI_CR2_DS_3             (0x8U << SPI_CR2_DS_Pos)                      /*!< 0x00000800 */
#define SPI_CR2_FRXTH_Pos        (12U)
#define SPI_CR2_FRXTH_Msk        (0x1U << SPI_CR2_FRXTH_Pos)                   /*!< 0x00001000 */
#define SPI_CR2_FRXTH            SPI_CR2_FRXTH_Msk                             /*!< FIFO reception Threshold */
#define SPI_CR2_LDMARX_Pos       (13U)
#define SPI_CR2_LDMARX_Msk       (0x1U << SPI_CR2_LDMARX_Pos)                  /*!< 0x00002000 */
#define SPI_CR2_LDMARX           SPI_CR2_LDMARX_Msk                            /*!< Last DMA transfer for reception */
#define SPI_CR2_LDMATX_Pos       (14U)
#define SPI_CR2_LDMATX_Msk       (0x1U << SPI_CR2_LDMATX_Pos)                  /*!< 0x00004000 */
#define SPI_CR2_LDMATX           SPI_CR2_LDMATX_Msk                            /*!< Last DMA transfer for transmission */

/********************  Bit definition for SPI_SR register  ********************/
#define SPI_SR_RXNE_Pos          (0U)
#define SPI_SR_RXNE_Msk          (0x1U << SPI_SR_RXNE_Pos)                     /*!< 0x00000001 */
#define SPI_SR_RXNE              SPI_SR_RXNE_Msk                               /*!< Receive buffer Not Empty */
#define SPI_SR_TXE_Pos           (1U)
#define SPI_SR_TXE_Msk           (0x1U << SPI_SR_TXE_Pos)                      /*!< 0x00000002 */
#define SPI_SR_TXE               SPI_SR_TXE_Msk                                /*!< Transmit buffer Empty */
#define SPI_SR_CHSIDE_Pos        (2U)
#define SPI_SR_CHSIDE_Msk        (0x1U << SPI_SR_CHSIDE_Pos)                   /*!< 0x00000004 */
#define SPI_SR_CHSIDE            SPI_SR_CHSIDE_Msk                             /*!< Channel side */
#define SPI_SR_UDR_Pos           (3U)
#define SPI_SR_UDR_Msk           (0x1U << SPI_SR_UDR_Pos)                      /*!< 0x00000008 */
#define SPI_SR_UDR               SPI_SR_UDR_Msk                                /*!< Underrun flag */
#define SPI_SR_CRCERR_Pos        (4U)
#define SPI_SR_CRCERR_Msk        (0x1U << SPI_SR_CRCERR_Pos)                   /*!< 0x00000010 */
#define SPI_SR_CRCERR            SPI_SR_CRCERR_Msk                             /*!< CRC Error flag */
#define SPI_SR_MODF_Pos          (5U)
#define SPI_SR_MODF_Msk          (0x1U << SPI_SR_MODF_Pos)                     /*!< 0x00000020 */
#define SPI_SR_MODF              SPI_SR_MODF_Msk                               /*!< Mode fault */
#define SPI_SR_OVR_Pos           (6U)
#define SPI_SR_OVR_Msk           (0x1U << SPI_SR_OVR_Pos)                      /*!< 0x00000040 */
#define SPI_SR_OVR               SPI_SR_OVR_Msk                                /*!< Overrun flag */
#define SPI_SR_BSY_Pos           (7U)
#define SPI_SR_BSY_Msk           (0x1U << SPI_SR_BSY_Pos)                      /*!< 0x00000080 */
#define SPI_SR_BSY               SPI_SR_BSY_Msk                                /*!< Busy flag */
#define SPI_SR_FRE_Pos           (8U)
#define SPI_SR_FRE_Msk           (0x1U << SPI_SR_FRE_Pos)                      /*!< 0x00000100 */
#define SPI_SR_FRE               SPI_SR_FRE_Msk                                /*!< TI frame format error */
#define SPI_SR_FRLVL_Pos         (9U)
#define SPI_SR_FRLVL_Msk         (0x3U << SPI_SR_FRLVL_Pos)                    /*!< 0x00000600 */
#define SPI_SR_FRLVL             SPI_SR_FRLVL_Msk                              /*!< FIFO Reception Level */
#define SPI_SR_FRLVL_0           (0x1U << SPI_SR_FRLVL_Pos)                    /*!< 0x00000200 */
#define SPI_SR_FRLVL_1           (0x2U << SPI_SR_FRLVL_Pos)                    /*!< 0x00000400 */
#define SPI_SR_FTLVL_Pos         (11U)
#define SPI_SR_FTLVL_Msk         (0x3U << SPI_SR_FTLVL_Pos)                    /*!< 0x00001800 */
#define SPI_SR_FTLVL             SPI_SR_FTLVL_Msk                              /*!< FIFO Transmission Level */
#define SPI_SR_FTLVL_0           (0x1U << SPI_SR_FTLVL_Pos)                    /*!< 0x00000800 */
#define SPI_SR_FTLVL_1           (0x2U << SPI_SR_FTLVL_Pos)                    /*!< 0x00001000 */

/********************  Bit definition for SPI_DR register  ********************/
#define SPI_DR_DR_Pos            (0U)
#define SPI_DR_DR_Msk            (0xFFFFU << SPI_DR_DR_Pos)                    /*!< 0x0000FFFF */
#define SPI_DR_DR                SPI_DR_DR_Msk                                 /*!<Data Register           */

/*******************  Bit definition for SPI_CRCPR register  ******************/
#define SPI_CRCPR_CRCPOLY_Pos    (0U)
#define SPI_CRCPR_CRCPOLY_Msk    (0xFFFFU << SPI_CRCPR_CRCPOLY_Pos)            /*!< 0x0000FFFF */
#define SPI_CRCPR_CRCPOLY        SPI_CRCPR_CRCPOLY_Msk                         /*!<CRC polynomial register */

/******************  Bit definition for SPI_RXCRCR register  ******************/
#define SPI_RXCRCR_RXCRC_Pos     (0U)
#define SPI_RXCRCR_RXCRC_Msk     (0xFFFFU << SPI_RXCRCR_RXCRC_Pos)             /*!< 0x0000FFFF */
#define SPI_RXCRCR_RXCRC         SPI_RXCRCR_RXCRC_Msk                          /*!<Rx CRC Register         */

/******************  Bit definition for SPI_TXCRCR register  ******************/
#define SPI_TXCRCR_TXCRC_Pos     (0U)
#define SPI_TXCRCR_TXCRC_Msk     (0xFFFFU << SPI_TXCRCR_TXCRC_Pos)             /*!< 0x0000FFFF */
#define SPI_TXCRCR_TXCRC         SPI_TXCRCR_TXCRC_Msk                          /*!<Tx CRC Register         */

#endif	// UNIT_TEST_INCLUDE_MOCKS_CHIP_STM32_SPIV2_SPIPERIPHERAL_HPP_DISTORTOS_CHIP_STM32_SPIV2_SPIPERIPHERAL_HPP_
