/**
 * \file
 * \brief wasteTime() implementation
 *
 * \author Copyright (C) 2014 Kamil Szczygiel https://distortec.com https://freddiechopin.info
 *
 * \par License
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. If a copy of the MPL was not
 * distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

#include "wasteTime.hpp"

namespace distortos
{

namespace test
{

/*---------------------------------------------------------------------------------------------------------------------+
| global functions
+---------------------------------------------------------------------------------------------------------------------*/

void wasteTime(const TickClock::duration duration)
{
	/// \todo implement something more precise and reliable
	for (TickClock::duration d {}; d <= duration; ++d)
		wasteTime(TickClock::now() + decltype(duration){1});
}

void wasteTime(const TickClock::time_point timePoint)
{
	while (timePoint > TickClock::now());
}

}	// namespace test

}	// namespace distortos
