# Softwaretechnologie: Java

<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-9-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
&nbsp;
[![GitHub forks](https://img.shields.io/github/forks/DH-Cologne/java-wegweiser.svg?label=forks&maxAge=2592000&style=flat-square)](https://GitHub.com/DH-Cologne/java-wegweiser/network/members "Make your own fork today!")
&nbsp;
[![GitHub issues](https://img.shields.io/github/issues/DH-Cologne/java-wegweiser.svg?style=flat-square&label=issues)](https://GitHub.com/DH-Cologne/java-wegweiser/issues/ "There are this many open issues!")
&nbsp;
[![Visitors](https://hits.webklex.com/svg/dh-cologne/java-wegweiser-index)](https://github.com/DH-Cologne/java-wegweiser/graphs/traffic "Visitors since 2020/11/18")
<!-- &nbsp;
[![Repo Size](https://img.shields.io/github/repo-size/DH-Cologne/java-wegweiser.svg?label=Repo%20size&style=flat-square)](https://github.com/DH-Cologne/java-wegweiser) -->


Ein Wegweiser zur Java-Programmierung, der mit seinen Aufgaben wächst. Für die Teilnehmer*innen des Moduls **"Softwaretechnologie: Java"** der Studiengänge **Informationsverarbeitung** und **Medieninformatik** am **IDH** (**I**nstitut für **D**igital **H**umanities, Universität zu Köln) und für alle Interessierten! 👐

> **Work in progress.** 🚧 🐌
Diese Lern- und Orientierungs-Ressource ist weit davon entfernt, vollständig zu sein. Aber das ist okay. Wenn dir auffällt, dass etwas Wichtiges fehlt oder unzureichend erläutert ist, dann [eröffne ein Issue](https://github.com/dh-cologne/java-wegweiser/issues) oder [trage eigene Änderungen bei](Mitwirken.md)!


## Übrigens 💬
📖 &nbsp; [**Inhalt**](#inhalt-book) &mdash; Zum Inhaltsverzeichnis springen!
🤔 &nbsp; [**Was ist das hier**](Was-Ist-Das.md) &mdash; Bzw. was ist es nicht?
👩‍💻 &nbsp; [**Contributing**](Mitwirken.md) &mdash; Oder: Wie kann ich hier mitwirken?
🛋️ &nbsp; [**Lese-Ansicht**](https://dh-cologne.github.io/java-wegweiser) &mdash; Wenn du aus Versehen im Repository gelandet bist!
📕 &nbsp; [**Glossar**](Glossar.md) &mdash; Allgemeine Terminologie der Programmierung (wichtig)!
🔗 &nbsp; [**Link-Liste**](Links.md) &mdash; Weitere empfehlenswerte (online-) Ressourcen!
🏷 &nbsp; [**Java Naming Conventions**](articles/Naming-Conventions.md) ...wollen befolgt werden!




## Inhalt 📖

> 👉 Die einzelnen Themenbereiche sind hier mit `Schlagworten` kurz zusammengefasst. Die jeweilige Überschrift verlinkt auf das Dokument mit allen Inhalten zum entsprechenden Thema.




### Einstieg


#### [Benötigte Software](articles/Benoetigte-Software.md)
> `JDK` `Eclipse IDE` `Download` `Installation` ...

#### [Die Programmiersprache Java](articles/Die-Programmiersprache-Java.md)
> `Warum Java?` `Warum nicht?` `Besonderheiten` `Java Platform` `Java Ecosystem` `Packages` `Hello World!` ...

#### [Eclipse IDE](articles/Eclipse-IDE.md)
> `IDE` `Warum Eclipse?` `Workspaces` `Views` `Editor` `Die wichtigsten Funktionen` `Import` `Export` `Console` `Ausführen von Programmen` `Automatisch generierter Code`...



### Grundlagen

#### ["Hello World!" und die `main`-Methode](articles/Hello-World.md)
> `Das erste Programm` `Was ist das alles?` `main`

#### [Packages, `package` und `import`](articles/Packages-package-und-import.md)
> `Packages` `Pakete` `Paket-Pfade` `package` `import`

#### [Kommentare](articles/Kommentare.md)
> `// inline` `/* multi-line */`

#### [Variablen](articles/Variablen.md)
> `Was ist das?` `Syntax` `naming conventions` `Typisierung` ...

#### [Datentypen](articles/Datentypen.md)
> `primitive Datentypen` `komplexe Datentypen` `byte` `short` `int` `long` `float` `double` `boolean` `char` `default-Werte` `Wrapper-Klassen`...

#### [Casting](articles/Casting.md)
> `Typumwandlung` `implizit` `explizit` `upcast` `downcast` `cast-Operator` `Casting bei komplexen Datentypen` ...

#### [Operatoren](articles/Operatoren.md)
> `Rechenoperatoren` `Vergleichsoperatoren` `logische Operatoren` `Zuweisungsoperatoren` `+` `-` `*` `/` `%` `++` `--` `==` `!=` `>` `<` `>=` `<=` `&&` `||` `=` `+=` `-=` `/=` `*=` `%=` `&=` `|=` ...

#### [Strings / Zeichenketten](articles/Strings.md)
> `die Klasse "String"` `Literals` `special characters` `Unveränderbarkeit von Strings` `UTF-16` `String Formatting` ...

#### [Methoden](articles/Methoden.md)
> `Rückgabewerte` `Parameter/Argumente` `return` `Überlagerung` `Java ist immer pass-by-value` ...

#### [Conditional statements / Konditionale](articles/Konditionale.md)
> `if` `else` `:? (Ternary-Operator)` `switch`

#### [Schleifen](articles/Schleifen.md)
> `while` `do-while` `for` `for-each`

#### [Arrays](articles/Arrays.md)
> `Datenstrukturen` `Deklaration` `Typisierung` `Initialisierung` `Array Literals` `Zugriff` `Mehrdimensionale Arrays` ...

#### [Fehlerbehandlung](articles/Fehlerbehandlung.md)
> `Error` `Exception` `try` `catch` `finally` `try-with-resources` `throws` ...

#### [Dokumentation mit Javadoc](articles/Javadoc.md)
> `Wozu?` `/**` `@param` `@return` `<code></code>` `best practices` ...




### Objektorientierte Programmierung (OOP)


#### [OOP, Klassen und Objekte](articles/OOP-Klassen-und-Objekte.md)
> `Definition` `Nutzen` `Beispiele` `Klasse` `Objekt` `Kuchen` ...

#### [Objekte I: Initialisierung, Members, Zugriff](articles/Objekte-I-Initialisierung-Members-Zugriff.md)
> `new-Operator` `Instanzvariablen` `Instanzmethoden` `Zugriffs-/Sichtbarkeitsmodifizierer` `private` `(default)` `protected` `public` `this` `Getter` `Setter` `Konstruktoren` ...

#### [Static Members](articles/Static-Members.md)
> `static` `Klassenvariablen` `statische Methoden` ...

#### [Vererbung I: Grundlagen](articles/Vererbung-I-Grundlagen.md)
> `Wozu?` `Terminologie` `extends` `super` `instanceof-Operator` `Überschreiben von Methoden` ...

#### [`final`](articles/Final.md)
> `final` `finale Variablen` `finale Klassen` `finale Methoden` `Konstanten in Java` ...

#### [Objekte II: Repräsentation, Identität, Gleichheit](articles/Objekte-II-Repraesentation-Identitaet-Gleichheit.md)
> `toString()` `Objekt-Identität` `Objekt-Gleichheit` `equals()` `hashCode()` `Der Vertrag zwischen equals() und hashCode()` ...

#### [Vererbung II: Abstrakte Klassen und Methoden](articles/Vererbung-II-Abstrakte-Klassen-und-Methoden.md)
> `abstrakte Klassen` `abstrakte Methoden` `abstract` ...

#### [Vererbung III: Interfaces](articles/Vererbung-III-Interfaces.md)
> `Interfaces` `Erweiterung von Interfaces` `Default-Methoden` `Statische Methoden in Interfaces` ...

#### [Innere und anonyme Klassen](articles/Innere-und-anonyme-Klassen.md)
> `Anonyme Klassen` `Innere Klassen` ...




### Abstrakte Konzepte und Fortgeschrittenes


#### [Input / Output (I/O)](articles/IO.md)
> `Streams` `Buffering` `Reader` `Writer` `Objektserialisierung` `User-Input über Stdin` ...

#### [Datenstrukturen](articles/Datenstrukturen.md)
> `verkettete Listen` `zweifach verkettete Listen` `Binärbäume` `binäre Suchbäume` `siehe auch "Collections Framework"!` ...

#### [`Iterable` und `Iterator`](articles/Iterable-und-Iterator.md)
> `Iterable` `Iterator` `Bezug zu for-each` `Implementierung` ...

#### [Generics](articles/Generics.md)
> `Was?` `Wozu?` `<Syntax>` `Typsicherheit trotz generischer Programmierung` `Gültigkeit bei Kompilierung und zur Laufzeit` ...

#### [Collections Framework](articles/Collections-Framework.md)
> `Aufbau` `List` `Set` `Map` `Objekt-Identität im Kontext von HashMaps/HashSets` ...

#### [Enums](articles/Enums.md)
> `Enums` ...

#### [Rekursion](articles/Rekursion.md)
> `Um Rekursion zu verstehen, muss man zunächst Rekursion verstehen.`

#### [Vergleichen und Sortieren](articles/Vergleichen-Sortieren.md)
> `Comparable` `Comparator` `Collections.sort()` `Sortieralgorithmen` ...

#### [Multithreading](articles/Multithreading.md)
> `Prozess` `Thread` `Runnable` `synchronized` `volatile` ...

#### [Programmbibliotheken](articles/Programmbibliotheken.md)
> `Was?` `Wozu?` `Wie werden sie eingebunden?` `Maven` `Gradle` ...

#### [Unit-Tests](articles/JUnit.md)
> `Wozu?` `Schreiben von Unit-Tests` `Test-driven-development` `JUnit` ...

### Über den Seminarinhalt hinaus ...
... gehen die folgenden Themen. Das heißt jedoch nicht, dass sie nicht wichtig wären. Wer das Gelernte noch weiter vertiefen oder ergänzen möchte, kann sich von diesen Empfehlungen leiten lassen:

#### Java Stream API
🔗 [Introduction to Java 8 Streams](https://www.baeldung.com/java-8-streams-introduction) (baeldung.com)
🔗 [The Java 8 Stream API Tutorial](https://www.baeldung.com/java-8-streams) (baeldung.com)
🔗 [String Operations with Java Streams](https://www.baeldung.com/java-stream-operations-on-strings) (baeldung.com)
🔗 [Java Stream API](http://tutorials.jenkov.com/java-functional-programming/streams.html) (tutorials.jenkov.com)

#### Lambda Expressions und Functional Interfaces
🔗 [Lambda Expressions](https://docs.oracle.com/javase/tutorial/java/javaOO/lambdaexpressions.html) (docs.oracle.com)
🔗 [Java Functional Interfaces](https://beginnersbook.com/2017/10/java-functional-interfaces/) (beginnersbook.com)
🔗 [Lambda Expressions and Functional Interfaces: Tips and Best Practices](https://www.baeldung.com/java-8-lambda-expressions-tips) (baeldung.com)

#### Statische Methoden in Interfaces
🔗 [Static and Default Methods in Interfaces in Java](https://www.baeldung.com/java-static-default-methods) (baeldung.com)
🔗 [Default and Static Methods in Interfaces in Java 8](https://codenuclear.com/default-and-static-methods-in-interfaces/) (codenuclear.com)





## Contributors ✨

Das ist alles. **Bis jetzt!** Wie wäre es mit [**deinem Beitrag**](Mitwirken.md)?

Dank für die Mitarbeit an diesem Repository gebührt den folgenden fleißigen Mitwirkenden ([emoji legende](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/bkis"><img src="https://avatars0.githubusercontent.com/u/9215743?v=4?s=80" width="80px;" alt=""/><br /><sub><b>bkis</b></sub></a><br /><a href="#content-bkis" title="Content">🖋</a> <a href="#example-bkis" title="Examples">💡</a> <a href="#ideas-bkis" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-bkis" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/hntFulvan"><img src="https://avatars3.githubusercontent.com/u/64469511?v=4?s=80" width="80px;" alt=""/><br /><sub><b>Nicolas David Werner</b></sub></a><br /><a href="#content-hntFulvan" title="Content">🖋</a> <a href="#example-hntFulvan" title="Examples">💡</a></td>
    <td align="center"><a href="https://github.com/Lelalue"><img src="https://avatars1.githubusercontent.com/u/34158237?v=4?s=80" width="80px;" alt=""/><br /><sub><b>Lelalue</b></sub></a><br /><a href="#content-Lelalue" title="Content">🖋</a> <a href="#example-Lelalue" title="Examples">💡</a></td>
    <td align="center"><a href="https://github.com/mkamphausen"><img src="https://avatars2.githubusercontent.com/u/43293625?v=4?s=80" width="80px;" alt=""/><br /><sub><b>mkamphausen</b></sub></a><br /><a href="#content-mkamphausen" title="Content">🖋</a> <a href="#example-mkamphausen" title="Examples">💡</a></td>
    <td align="center"><a href="http://#"><img src="https://avatars2.githubusercontent.com/u/29183752?v=4?s=80" width="80px;" alt=""/><br /><sub><b>Julian Kamphausen</b></sub></a><br /><a href="#content-jkamphausen" title="Content">🖋</a> <a href="#example-jkamphausen" title="Examples">💡</a></td>
    <td align="center"><a href="https://github.com/Demirro"><img src="https://avatars3.githubusercontent.com/u/44236116?v=4?s=80" width="80px;" alt=""/><br /><sub><b>Demirro</b></sub></a><br /><a href="#ideas-Demirro" title="Ideas, Planning, & Feedback">🤔</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/vgavrilova"><img src="https://avatars2.githubusercontent.com/u/63244952?v=4?s=80" width="80px;" alt=""/><br /><sub><b>Valeria Gavrilova</b></sub></a><br /><a href="https://github.com/DH-Cologne/java-wegweiser/issues?q=author%3Avgavrilova" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/jspringe-stu"><img src="https://avatars.githubusercontent.com/u/74214197?v=4?s=80" width="80px;" alt=""/><br /><sub><b>jspringe</b></sub></a><br /><a href="#content-jspringe-stu" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/sandeepmishratech"><img src="https://avatars.githubusercontent.com/u/87706790?v=4?s=80" width="80px;" alt=""/><br /><sub><b>Sandeep Mishra</b></sub></a><br /><a href="#content-sandeepmishratech" title="Content">🖋</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

> 👉 **Dieses Projekt folgt der [all-contributors](https://github.com/all-contributors/all-contributors)-Spezifikation.**
> Contributions (Beiträge) jeder Art [sind willkommen](Mitwirken.md) und werden an dieser Stelle wie oben zu sehen aufgeführt!
