# Link-Liste 🔗<!-- omit in toc -->

> Kategorisierte Links zu allgemeinen, Modul-relevanten Ressourcen, die begleitend genutzt werden können

- [Java Lernen 📚](#java-lernen-books)
- [Java Üben 👨‍💻](#java-üben-man_technologist)
- [Anleitungen 👩‍🏫](#anleitungen-woman_teacher)
- [Downloads 💾](#downloads-floppy_disk)
- [Git](#git)
- [Sonstiges 🥗](#sonstiges-green_salad)

## Java Lernen 📚

-   [Programmieren in Java: Einführung](http://www.highscore.de/java/einfuehrung/) - Eine nüchterne, aber informative Einführung zum Durchlesen (weniger zum Nachschlagen)
-   [WikiBooks: Java Programming](https://en.wikibooks.org/wiki/Java_Programming) - Eine ganz ähnliche Ressource wie dieses Repository, aber auf Englisch. Sehr gut und auf den Punkt, sehr empfehlenswert!
-   [WikiBooks: Java Standard](https://de.wikibooks.org/wiki/Java_Standard) - Ein offenes Lehrbuch für Java (auf Deutsch); nicht so gut aufgearbeitet wie die englische Variante (siehe oben)
-   [Oracle Java Tutorial](https://docs.oracle.com/javase/tutorial/java/) - Etwas trocken und angestaubt, aber bewährt
-   [Java ist auch eine Insel](http://openbook.rheinwerk-verlag.de/javainsel/) - Solides Lehrbuch, kostenlos online
-   [Operators in Java](https://www.codejava.net/java-core/the-java-language/summary-of-operators-in-java-with-examples) - Übersicht über jegliche Operatoren in Java


## Java Üben 👨‍💻

-   [w3schools Java Exercises](https://www.w3schools.com/java/java_exercises.asp) - Eine Art Quiz, das die Grundlagen abfragt
-   [Core Java Quiz](https://www.javatpoint.com/core-java-quiz) - Noch eine Sammlung von Quiz-Fragen zum Üben der Grundlagen
-   [CodingBat - Java](https://codingbat.com/java) - Übungen zu verschiedenen Themen in verschiedenen Schwierigkeitsgraden
-   [Exercism - Exercises on the Java track](https://exercism.io/tracks/java/exercises) - Sehr schöne, übersichtliche Seite mit vielen (!) kleinen, verspielten Übungen
-   [Programming by Doing](http://www.programmingbydoing.com/) - Lange Liste mit Übungen
-   [Mega Project List](https://github.com/karan/Projects) - Schönes Git-Repo auf GitHub mit etlichen kleinen und großen Projekten und Übungen
-   [w3resource Java Programming Exercises and Solutions](https://www.w3resource.com/java-exercises/) - Sehr viele Übungen (mit Lösungen) zu bestimmten Konzepten
-   [Project Euler](https://projecteuler.net/) - Programmier-Probleme (hauptsächlich mathematische); unabhängig von der Programmiersprache; relativ fortgeschritten
-   [/r/dailyprogrammer](https://www.reddit.com/r/dailyprogrammer/) - Ein Subreddit (reddit-Themenseite) zu täglichen Programmier-Herausforderungen
-   [Weitere Ideen für Übungsaufgaben](https://duckduckgo.com/?q=java+programming+ideas+exercise) - Ja, der Link führt zu einem Suchmaschinen-Ergebnis. Das Internet ist eben voll von Problemen ...


## Anleitungen 👩‍🏫

-   [Einstieg in Eclipse](http://www.java-programmieren.com/eclipse-erste-schritte.php) - "In diesem Eclipse Tutorial werden die erste Schritte in Eclipse aufgezeit, beispielsweie wie man ein Projekt anlegt und in diesem dann die erste Klasse samt Java-Code erstellt."
-   [Java Debugging with Eclipse](https://www.vogella.com/tutorials/EclipseDebugging/article.html) - Wie funktioniert der debugger in Eclipse?


## Downloads 💾

-   [Eclipse IDE](https://www.eclipse.org/downloads/packages/release/2020-03/r/eclipse-ide-java-developers) - Die Entwicklungsumgebung Eclipse für verschiedene Plattformen
-   [AdoptOpenJDK](https://adoptopenjdk.net/releases.html) - Eine Quelle für ein OpenJDK mit Downloads für viele Betriebssysteme
-   [Git](https://git-scm.com/downloads) - Quellcode-Versionsierung für Profis
-   [Git for Windows](https://gitforwindows.org/) - Enthält sogar einen Bash-Emulator (Unix-Terminal) für Windows!


## Git 

-   [Git Book](https://git-scm.com/book/de/v2) - Offizielle Ressource: Lernen, mit Git zu arbeiten
-   [Git Community Book](https://shafiul.github.io/gitbook/) - Ressource aus der Community: Wie "Git Book", nur vielleicht sogar besser
-   [Git Guides](https://github.com/git-guides/) - von GitHub zur Verfügung gestellte Ressource zum Lernen von Git
-   [Git einfach erklärt](https://rogerdudler.github.io/git-guide/index.de.html) - Eine sehr einfache, gut verständliche, dafür aber auch nicht ganz vollständige Anleitung zu Git. Gut für den Einstieg!
-   [Interactive Git Cheat Sheet](http://ndpsoftware.com/git-cheatsheet.html) - Sehr gute Übersicht über die meisten Git-Befehle (mit visueller Einordnung in Anwendungsbereiche!)
-   [Git Cheat Sheet PDF](assets/documents/Git-Cheat-Sheet.pdf) - Die allerwichtigsten Git-Befehle auf einer überlichtlichen Seite!
-   [CS visualized: Useful Git commands](https://dev.to/lydiahallie/cs-visualized-useful-git-commands-37p1) - Sehr gut geeignet, um einige komplexere Vorgänge in Git zu verstehen
-   [Visualizing Git](https://github.com/git-school/visualizing-git) - eine Visualisierung der üblichsten Git-Befehle (zum Verständnis)
-   🎮️ [Oh my Git!](https://ohmygit.org/) - Open Source Computerspiel (Windows / Mac OS / Linux) zum Git lernen  

## Sonstiges 🥗

-   [StackOverflow](https://stackoverflow.com/) - Nur für den Fall, dass es jemand noch nicht kennt (Englisch)
-   [DEV.to](https://dev.to/) - Freundliche Community, die sich gut gelaunt mit Themen zur Software-Entwicklung im Allgemeinen auseinandersetzt (Englisch)
-   [Visualisierte Sortier-Algorithmen](https://www.toptal.com/developers/sorting-algorithms) - Für wenn man's mal braucht





