﻿using Abp.Modules;
using Abp.MultiTenancy;
using Abp.TestBase;
using Abp.Zero.Configuration;
using Castle.MicroKernel.Registration;
using NSubstitute;

namespace CzuczenLand.Tests;

[DependsOn(
    typeof(CzuczenLandApplicationModule),
    typeof(CzuczenLandDataModule),
    typeof(AbpTestBaseModule))]
public class CzuczenLandTestModule : AbpModule
{
    public override void PreInitialize()
    {
        //Use database for language management
        Configuration.Modules.Zero().LanguageManagement.EnableDbLocalization();

        //Registering fake services

        IocManager.IocContainer.Register(
            Component.For<IAbpZeroDbMigrator>()
                .UsingFactoryMethod(() => Substitute.For<IAbpZeroDbMigrator>())
                .LifestyleSingleton()
        );
    }
}