using Abp.Authorization;
using Abp.Authorization.Roles;
using Abp.Domain.Repositories;
using Abp.Domain.Uow;
using Abp.Organizations;
using Abp.Runtime.Caching;
using Abp.Zero.Configuration;
using CzuczenLand.Authorization.Users;

namespace CzuczenLand.Authorization.Roles;

public class RoleManager : AbpRoleManager<Role, User>
{
    public RoleManager(
        RoleStore store,
        IPermissionManager permissionManager,
        IRoleManagementConfig roleManagementConfig,
        ICacheManager cacheManager,
        IUnitOfWorkManager unitOfWorkManager,
        IRepository<OrganizationUnit, long> organizationUnitRepository,
        IRepository<OrganizationUnitRole, long> organizationUnitRoleRepository)
        : base(
            store,
            permissionManager,
            roleManagementConfig,
            cacheManager,
            unitOfWorkManager,
            organizationUnitRepository,
            organizationUnitRoleRepository)
    {
    }
}