﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.ViewParser;

/// <summary>
/// Klasa przechowująca nazwy pól związanych z relacjami.
/// </summary>
public static class RelationFieldsNames
{
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z identyfikatorem typu generowanego.
    /// </summary>
    public const string GeneratedTypeId = "GeneratedTypeId";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z identyfikatorem użytkownika.
    /// </summary>
    public const string UserId = "UserId";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z identyfikatorem dzielnicy.
    /// </summary>
    public const string DistrictId = "DistrictId";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z identyfikatorem magazynu plantacji.
    /// </summary>
    public const string PlantationStorageId = "PlantationStorageId";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z identyfikatorem magazynu gracza.
    /// </summary>
    public const string PlayerStorageId = "PlayerStorageId";
        
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z nazwą encji.
    /// </summary>
    public const string EntityName = "EntityName";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z typem zadania.
    /// </summary>
    public const string QuestType = "QuestType";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z warunkiem wymagania.
    /// </summary>
    public const string Condition = "Condition";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z porównaniem wymagania.
    /// </summary>
    public const string Comparer = "Comparer";
    
    /// <summary>
    /// Pole reprezentujące nazwę pola związanego z niestandardową nazwą encji.
    /// </summary>
    public const string CustomEntityName = "CustomEntityName";
}