﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Requirement.Comparers;

/// <summary>
/// Klasa przechowująca nazwy porównań wymagania czytelne dla użytkownika.
/// </summary>
public static class HrComparers
{
    /// <summary>
    /// Nazwa porównania reprezentującego posiadaną ilość.
    /// </summary>
    public const string OwnedAmount = "Posiadana ilość (wszystkie produkty)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego poziom.
    /// </summary>
    public const string Level = "Poziom (magazyn plantacji lub magazyn gracza)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego otrzymane doświadczenie.
    /// </summary>
    public const string GainedExperience = "Otrzymane doświadczenie (magazyn plantacji lub magazyn gracza)";

    /// <summary>
    /// Nazwa porównania reprezentującego ilość złota.
    /// </summary>
    public const string Gold = "Złoto (magazyn plantacji lub magazyn gracza)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego prestiż.
    /// </summary>
    public const string Prestige = "Prestiż (magazyn plantacji)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego ilość ukończonych zadań.
    /// </summary>
    public const string CompletedAmount = "Ilość ukończonych (zadanie)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego ilość użyć bonusu.
    /// </summary>
    public const string Usages = "Użycia (bonus)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego zbieranie rośliny.
    /// </summary>
    public const string CollectPlant = "Zbierz roślinę";
    
    /// <summary>
    /// Nazwa porównania reprezentującego usuwanie rośliny.
    /// </summary>
    public const string RemovePlant = "Wyrzuć roślinę";
    
    /// <summary>
    /// Nazwa porównania reprezentującego tworzenie rośliny.
    /// </summary>
    public const string CreatePlant = "Stwórz roślinę";
    
    /// <summary>
    /// Nazwa porównania reprezentującego sprzedaż na czarnym rynku.
    /// </summary>
    public const string SellOnBlackMarket = "Sprzedaj na czarnym rynku";
    
    /// <summary>
    /// Nazwa porównania reprezentującego zakup na czarnym rynku.
    /// </summary>
    public const string BuyOnBlackMarket = "Kup na czarnym rynku";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton zadania.
    /// </summary>
    public const string QuestToken = "Żeton zadania (magazyn plantacji)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton dealera.
    /// </summary>
    public const string DealerToken = "Żeton dealera (magazyn plantacji)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton czarnego rynku.
    /// </summary>
    public const string BlackMarketToken = "Żeton czarnego rynku (magazyn plantacji)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton dona.
    /// </summary>
    public const string DonToken = "Żeton dona (magazyn plantacji)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton odblokowania.
    /// </summary>
    public const string UnlockToken = "Żeton odblokowania (magazyn plantacji)";
    
    /// <summary>
    /// Nazwa porównania reprezentującego honor.
    /// </summary>
    public const string Honor = "Honor (magazyn gracza)";
}