﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Requirement.Comparers;

/// <summary>
/// Klasa przechowująca nazwy porównań wymagania w bazie danych.
/// </summary>
public static class DbComparers
{
    /// <summary>
    /// Nazwa porównania reprezentującego posiadaną ilość.
    /// </summary>   
    public const string OwnedAmount = "OwnedAmount";
    
    /// <summary>
    /// Nazwa porównania reprezentującego poziom.
    /// </summary>
    public const string Level = "Level";
    
    /// <summary>
    /// Nazwa porównania reprezentującego otrzymane doświadczenie.
    /// </summary>
    public const string GainedExperience = "GainedExperience";
    
    /// <summary>
    /// Nazwa porównania reprezentującego ilość złota.
    /// </summary>
    public const string Gold = "Gold";
    
    /// <summary>
    /// Nazwa porównania reprezentującego prestiż.
    /// </summary>
    public const string Prestige = "Prestige";
    
    /// <summary>
    /// Nazwa porównania reprezentującego ilość ukończonych zadań.
    /// </summary>
    public const string CompletedAmount = "CompletedAmount";
    
    /// <summary>
    /// Nazwa porównania reprezentującego ilość użyć bonusu.
    /// </summary>
    public const string Usages = "Usages";
    
    /// <summary>
    /// Nazwa porównania reprezentującego zbieranie rośliny.
    /// </summary>
    public const string CollectPlant = "CollectPlant";
    
    /// <summary>
    /// Nazwa porównania reprezentującego usuwanie rośliny.
    /// </summary>
    public const string RemovePlant = "RemovePlant";
    
    /// <summary>
    /// Nazwa porównania reprezentującego tworzenie rośliny.
    /// </summary>
    public const string CreatePlant = "CreatePlant";
    
    /// <summary>
    /// Nazwa porównania reprezentującego sprzedaż na czarnym rynku.
    /// </summary>
    public const string SellOnBlackMarket = "SellOnBlackMarket";
    
    /// <summary>
    /// Nazwa porównania reprezentującego zakup na czarnym rynku.
    /// </summary>
    public const string BuyOnBlackMarket = "BuyOnBlackMarket";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton zadania.
    /// </summary>
    public const string QuestToken = "QuestToken";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton dealera.
    /// </summary>
    public const string DealerToken = "DealerToken";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton czarnego rynku.
    /// </summary>
    public const string BlackMarketToken = "BlackMarketToken";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton dona.
    /// </summary>
    public const string DonToken = "DonToken";
    
    /// <summary>
    /// Nazwa porównania reprezentującego żeton odblokowania.
    /// </summary>
    public const string UnlockToken = "UnlockToken";
    
    /// <summary>
    /// Nazwa porównania reprezentującego honor.
    /// </summary>
    public const string Honor = "Honor";
}