﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.SharedEntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól produktu czytelne dla użytkownika.
/// </summary>
public static class ProductFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego nazwę produktu.
    /// </summary>
    public const string Name = "Nazwa";
    
    /// <summary>
    /// Nazwa pola opisującego wymagany poziom plantacji dla produktu.
    /// </summary>
    public const string PlantationLevelRequirement = "Wymagany poziom plantacji";
    
    /// <summary>
    /// Nazwa pola opisującego cenę sprzedaży produktu.
    /// </summary>
    public const string SellPrice = "Cena sprzedaży";
    
    /// <summary>
    /// Nazwa pola opisującego cenę kupna produktu.
    /// </summary>
    public const string BuyPrice = "Cena kupna";
    
    /// <summary>
    /// Nazwa pola informującego, czy produkt jest przedmiotem sklepu.
    /// </summary>
    public const string IsShopItem = "Czy jest to przedmiot sklepu";
    
    /// <summary>
    /// Nazwa pola informującego, czy produkt jest przedmiotem pracownika czarnego rynku.
    /// </summary>
    public const string IsBlackMarketWorkerItem = "Czy jest to przedmiot pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola informującego, czy gracz może sprzedawać produkt na czarnym rynku.
    /// </summary>
    public const string PlayerCanSellInBlackMarket = "Czy gracz może sprzedawać na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego ilość posiadanych produktów.
    /// </summary>
    public const string OwnedAmount = "Posiadana ilość";
    
    /// <summary>
    /// Nazwa pola opisującego nazwę zestawu, do którego należy produkt.
    /// </summary>
    public const string SetName = "Nazwa zestawu";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną cenę sprzedaży produktu na czarnym rynku.
    /// </summary>
    public const string BlackMarketMaxSellPrice = "Maksymalna cena na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego minimalną cenę sprzedaży produktu na czarnym rynku.
    /// </summary>
    public const string BlackMarketMinSellPrice = "Minimalna cena na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola identyfikującego potrzebę zignorowania zmiany.
    /// </summary>
    public const string IgnoreChangeGuid = "Identyfikator potrzeby zignorowania zmiany";
}