﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesNames.Base;

/// <summary>
/// Klasa przechowująca nazwy encji w bazie danych.
/// </summary>
public static class EntitiesDbNames
{
    /// <summary>
    /// Nazwa encji reprezentującej susz.
    /// </summary>
    public const string DriedFruit = "DriedFruit";
    
    /// <summary>
    /// Nazwa encji reprezentującej lampę.
    /// </summary>
    public const string Lamp = "Lamp";
    
    /// <summary>
    /// Nazwa encji reprezentującej nawóz.
    /// </summary>
    public const string Manure = "Manure";
    
    /// <summary>
    /// Nazwa encji reprezentującej doniczkę.
    /// </summary>
    public const string Pot = "Pot";
    
    /// <summary>
    /// Nazwa encji reprezentującej nasiono.
    /// </summary>
    public const string Seed = "Seed";
    
    /// <summary>
    /// Nazwa encji reprezentującej glebę.
    /// </summary>
    public const string Soil = "Soil";
    
    /// <summary>
    /// Nazwa encji reprezentującej wodę.
    /// </summary>
    public const string Water = "Water";
    
    /// <summary>
    /// Nazwa encji reprezentującej wzmocnienie/artefakt.
    /// </summary>
    public const string Bonus = "Bonus";
    
    /// <summary>
    /// Nazwa encji reprezentującej nowości.
    /// </summary>
    public const string News = "News";
    
    /// <summary>
    /// Nazwa encji reprezentującej użytkownika.
    /// </summary>
    public const string User = "User";
    
    /// <summary>
    /// Nazwa encji reprezentującej nagrodę.
    /// </summary>
    public const string Drop = "Drop";
    
    /// <summary>
    /// Nazwa encji reprezentującej magazyn plantacji.
    /// </summary>
    public const string PlantationStorage = "PlantationStorage";
    
    /// <summary>
    /// Nazwa encji reprezentującej roślinę.
    /// </summary>
    public const string Plant = "Plant";
    
    /// <summary>
    /// Nazwa encji reprezentującej magazyn gracza.
    /// </summary>
    public const string PlayerStorage = "PlayerStorage";
    
    /// <summary>
    /// Nazwa encji reprezentującej zadanie.
    /// </summary>
    public const string Quest = "Quest";
    
    /// <summary>
    /// Nazwa encji reprezentującej wymaganie.
    /// </summary>
    public const string Requirement = "Requirement";
    
    /// <summary>
    /// Nazwa encji reprezentującej dzielnicę.
    /// </summary>
    public const string District = "District";
    
    /// <summary>
    /// Nazwa encji reprezentującej typ generowany.
    /// </summary>
    public const string GeneratedType = "GeneratedType";
    
    /// <summary>
    /// Nazwa encji reprezentującej relację nagrody do zadania.
    /// </summary>
    public const string DropQuest = "DropQuest";
    
    /// <summary>
    /// Nazwa encji reprezentującej progres wymagań zadania.
    /// </summary>
    public const string QuestRequirementsProgress = "QuestRequirementsProgress";
}