﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól zadań czytelne dla użytkownika.
/// </summary>
public static class QuestFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego czas trwania zadania.
    /// </summary>
    public const string Duration = "Czas trwania (sekundy)";
    
    /// <summary>
    /// Nazwa pola opisującego czy zadanie jest ukończone.
    /// </summary>
    public const string IsComplete = "Jest kompletny";
    
    /// <summary>
    /// Nazwa pola opisującego typ zadania.
    /// </summary>
    public const string QuestType = "Typ zadania";
    
    /// <summary>
    /// Nazwa pola opisującego ilość ukończonych zadań.
    /// </summary>
    public const string CompletedAmount = "Ilość ukończonych";
    
    /// <summary>
    /// Nazwa pola opisującego wymagany poziom plantacji dla zadania.
    /// </summary>
    public const string PlantationLevelRequirement = "Wymagany poziom plantacji (nic dla osiągnięć)";
    
    /// <summary>
    /// Nazwa pola opisującego czas rozpoczęcia dostępności zadania.
    /// </summary>
    public const string StartTime = "Od kiedy zadanie ma być dostępne";
    
    /// <summary>
    /// Nazwa pola opisującego czas zakończenia dostępności zadania.
    /// </summary>
    public const string EndTime = "Do kiedy zadanie ma być dostępne";
    
    /// <summary>
    /// Nazwa pola opisującego aktualny czas trwania zadania.
    /// </summary>
    public const string CurrentDuration = "Aktualny czas trwania";
    
    /// <summary>
    /// Nazwa pola opisującego czy zadanie jest dostępne od początku.
    /// </summary>
    public const string IsAvailableInitially = "Czy jest dostępne od początku";
    
    /// <summary>
    /// Nazwa pola opisującego czy zadanie jest powtarzalne.
    /// </summary>
    public const string IsRepetitive = "Czy jest powtarzalne";
    
    /// <summary>
    /// Nazwa pola opisującego czy zadanie jest w trakcie.
    /// </summary>
    public const string InProgress = "Czy jest w trakcie";
    
    /// <summary>
    /// Nazwa pola opisującego czy zadanie typu wydarzenie zostało już wysłane przez pracownika.
    /// </summary>
    public const string WorkerSent = "Czy wydarzenie zostało już wysłane przez pracownika";
    
    /// <summary>
    /// Nazwa pola opisującego czas cykliczności zadania.
    /// </summary>
    public const string CyclicTime = "Czas cykliczności (minuty)";
}